﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/util/nifm_Base64.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class HttpPostData
{
public:
    static const int Size = 2 * 1024;

private:
    char m_Buffer[Size];
    int m_Length;

public:
    HttpPostData() NN_NOEXCEPT;
    ~HttpPostData() NN_NOEXCEPT;

    nn::Result EncodeAdd(const char* pKey, const char* pValue, int size) NN_NOEXCEPT;
    nn::Result DecodeAdd(const char* pValue) NN_NOEXCEPT;

    nn::Result EncodeAdd(const char* pKey, const char* pValue, int size, Base64::Mode mode) NN_NOEXCEPT;
    nn::Result DecodeAdd(const char* pValue, Base64::Mode mode) NN_NOEXCEPT;

    const char* GetPointer() const NN_NOEXCEPT;

    int GetLength() const NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;

};

}
}
}
