﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/nifm_TypesProxySetting.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpPostData.h>
#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpResponse.h>

#include <curl/curl.h>

namespace nn
{
namespace nifm
{
namespace detail
{

#define NIFM_DETAIL_CURL_EASY_SETOPT(p, o, ...)                                 \
    do                                                                          \
    {                                                                           \
        NN_RESULT_DO(CurlCodeToNnResult(curl_easy_setopt(p, o, __VA_ARGS__)));  \
    }                                                                           \
    while(NN_STATIC_CONDITION(false))


class HttpClientBase
{
private:
    static const uint32_t UrlSize = 1024;

protected:
    class HttpHeaderReaderBase
    {
    protected:
        struct Field
        {
            char name[32];
            char value[32];
        };

        bool ParseResponseHeaderLine(Field* pOutHttpHeaderField, const char* pInLine, int count) NN_NOEXCEPT;
        virtual void Parse(const char* pInLine, size_t size) = 0;
        virtual void Clear() = 0;

    public:
        HttpHeaderReaderBase() NN_NOEXCEPT;
        ~HttpHeaderReaderBase() NN_NOEXCEPT;
    };

    // SIGLO-38343 対応の workaround
    enum class SequencePeriod : uint8_t
    {
        ConnectionTest,
        AuthenticationNas,
        AuthenticationHotspot
    };

protected:
    NetworkInterfaceType m_NetworkInterfaceType;
    const ProxySetting* m_pProxySetting;

    CURL* m_pCurl;
    uint16_t m_StatusCode;
    HttpPostData* m_pHttpPostData;
    HttpResponse* m_pHttpResponse;

    SequencePeriod m_SequencePeriod;

protected:
    nn::Result CurlCodeToNnResult(CURLcode curlCode) const NN_NOEXCEPT;
    nn::Result CurlMCodeToNnResult(CURLMcode curlMCode) const NN_NOEXCEPT;

public:
    enum class HttpRequestMethod : uint8_t
    {
        Get,
        Post,
        Put,
        Delete,
    };

public:
    HttpClientBase() NN_NOEXCEPT;
    ~HttpClientBase() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Reset() NN_NOEXCEPT;

    // SIGLO-38343 対応の workaround
    void SetSequencePeriod(SequencePeriod sequencePeriod) NN_NOEXCEPT;

    void SetNetworkInterfaceType(nn::nifm::NetworkInterfaceType networkInterfaceType) NN_NOEXCEPT;
    void SetProxySetting(const ProxySetting& proxySetting) NN_NOEXCEPT;
    static int CurlSetSockOptsCallout(void *pData, curl_socket_t curlfd, curlsocktype purpose);
    void SetCurlCommonOpt() NN_NOEXCEPT;
    void SetRequestUrl(const char* pUrl) NN_NOEXCEPT;
    void SetRequesetMethod(HttpRequestMethod method) NN_NOEXCEPT;

    void SetPostDataBuffer(HttpPostData* pPostData) NN_NOEXCEPT;
    void SetResponseBuffer(HttpResponse* pResponse) NN_NOEXCEPT;

    nn::Result Connect() NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
};


}
}
}
