﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfp/nfp_DebugTypes.h>
#include <nn/nfp/nfp_PrivateTypes.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>
#include <nn/nfc/server/core/nfc_CoreService.h>
#include <nn/nfp/server/nfp_PlayReport.h>

namespace nn { namespace nfc { namespace server {
    class Device;
    class Tag;
}}}

namespace nn { namespace nfp { namespace server {

class Device
{
public:
    enum Call
    {
        Call_Mount,
        Call_SetApplicationArea,
        Call_SetRegisterInfo,
        Call_RecreateApplicationArea,
    };

public:
    explicit Device(nn::nfc::server::Device* device) NN_NOEXCEPT;
    ~Device() NN_NOEXCEPT;
    nn::Result Mount(nn::nfc::server::core::Service* service, ModelType modelType, MountTarget mountTarget) NN_NOEXCEPT;
    nn::Result Unmount() NN_NOEXCEPT;
    nn::Result OpenApplicationArea(nn::Bit32 accessId) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT;
    nn::Result SetApplicationArea(const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result RecreateApplicationArea(const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result Flush(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result Restore(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result CreateApplicationArea(nn::nfc::server::core::Service* service, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result GetCommonInfo(nn::nfp::CommonInfo* pOutCommonInfo) NN_NOEXCEPT;
    nn::Result GetModelInfo(nn::nfp::ModelInfo* pOutModelInfo) NN_NOEXCEPT;
    nn::Result Format(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result GetAdminInfo(nn::nfp::AdminInfo* pOutAdminInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfoPrivate* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result SetRegisterInfo(const nn::nfp::RegisterInfoPrivate& regInfo) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfo(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result DeleteApplicationArea(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result ExistsApplicationArea(bool* outValue) NN_NOEXCEPT;
    nn::Result GetAll(nn::nfp::NfpData* pOutNfpData) NN_NOEXCEPT;
    nn::Result SetAll(const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
    nn::Result FlushDebug(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result BreakTag(nn::nfc::server::core::Service* service, BreakType breakType) NN_NOEXCEPT;
    nn::Result WriteNtf(nn::nfc::server::core::Service* service, const void* pData, size_t dataSize, NtfWriteType ntfWriteType) NN_NOEXCEPT;
    static size_t GetApplicationAreaSize() NN_NOEXCEPT;

private:
    Device() NN_NOEXCEPT;
    nn::Result CheckMount() NN_NOEXCEPT;
    nn::Result CheckMountRam() NN_NOEXCEPT;
    nn::Result CheckMountRom() NN_NOEXCEPT;
    void SavePlayReport(const nn::nfp::ModelInfo& modelInfo) NN_NOEXCEPT;

private:
    nn::nfc::server::Device* m_Device;

    std::unique_ptr<nn::nfc::server::Tag> m_MountedTag;

    //プレイレポート用の情報
    nn::nfp::server::PlayReport::AccessInfo m_LastAccessInfo;
    Call m_LastCall;
};

}}}  // namespace nn::nfp::server
