﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/** @file
    @brief      エラーに対する UI 表示に関する API の宣言
*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace nfp {

/**
 * @name    エラーに対する UI 表示制御
 * @{
 */

/**
 * @brief 重大なエラーに対して UI を表示するか否かを設定します。
 *
 * @param[in] visible 表示するか否かを表す値
 *
 * @pre
 *  - GetState() == @ref State_Init
 *
 * @details
 *  ライブラリの利用で発生した発生した重大なエラーに対して UI を表示するか否かを設定します。@n
 *  ライブラリの初期化直後は true (表示する) に設定されています。@n
 *  「表示する」に設定している場合、以下 API の呼び出しで発生したシステムや NFC デバイスに関する重大なエラーに対して UI を表示します。@n
 *  - StartDetection()
 *  - StopDetection()
 *  - Mount()
 *  - Flush()
 *  - Restore()
 *  - CreateApplicationArea()
 *
 *  UI の表示よってアプリケーションの進行を妨げたくない場合などに「表示しない」設定を利用してください。
 *
 */
void SetErrorVisible(bool visible) NN_NOEXCEPT;

/**
 * @brief       重大なエラーに対して UI を表示するか否かを返します。
 *
 * @return      重大なエラーに対して UI を表示するか否かを表す値です。
 *
 * @pre
 *  - GetState() == @ref State_Init
 *
 * @details ライブラリの利用で発生した重大なエラーに対して UI を表示するか否かを返します。
 */
bool IsErrorVisible() NN_NOEXCEPT;

/**
 * @}
 */

}  // nfp
}  // nn
