﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

namespace nn { namespace nfc { namespace server { namespace util {

class ScopedMutexLock
{
public:
    explicit ScopedMutexLock(nn::os::MutexType& mutex) NN_NOEXCEPT;
    void Lock() NN_NOEXCEPT;
    void Unlock() NN_NOEXCEPT;
    ~ScopedMutexLock() NN_NOEXCEPT;

private:
    nn::os::MutexType& m_mutex;
    bool m_IsLocked;
};

}}}}  // namespace nn::nfc::server::util
