﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfc/nfc_MifareTypes.h>
#include <nn/nfc/nfc_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/xcd/xcd_NfcTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nfc { namespace mifare { namespace detail { // NOLINT(whitespace/braces)

class IUser;

class IUserManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUser, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfcMifare, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfcMifare)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteNfcMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfcMifare, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfcMifare, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUser)

        ::nn::Result InitializeNfcMifare(::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeNfcMifare, (aruid, pid, mcuVersionData));
        }

        ::nn::Result FinalizeNfcMifare() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FinalizeNfcMifare);
        }

        ::nn::Result ListDevicesNfcMifare(const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDevicesNfcMifare, (devices, count));
        }

        ::nn::Result StartDetectionNfcMifare(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartDetectionNfcMifare, (deviceHandle));
        }

        ::nn::Result StopDetectionNfcMifare(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopDetectionNfcMifare, (deviceHandle));
        }

        ::nn::Result ReadNfcMifare(const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadNfcMifare, (blockData, deviceHandle, blockParameter));
        }

        ::nn::Result WriteNfcMifare(::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteNfcMifare, (deviceHandle, blockParameter));
        }

        ::nn::Result GetTagInfoNfcMifare(::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTagInfoNfcMifare, (tagInfo, deviceHandle));
        }

        ::nn::Result GetActivateEventHandleNfcMifare(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfcMifare, (handle, deviceHandle));
        }

        ::nn::Result GetDeactivateEventHandleNfcMifare(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfcMifare, (handle, deviceHandle));
        }

        ::nn::Result GetStateNfcMifare(::nn::sf::Out<::nn::Bit32> state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateNfcMifare, (state));
        }

        ::nn::Result GetDeviceStateNfcMifare(::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceStateNfcMifare, (state, deviceHandle));
        }

        ::nn::Result GetNpadIdNfcMifare(::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadIdNfcMifare, (npadId, deviceHandle));
        }

        ::nn::Result GetAvailabilityChangeEventHandleNfcMifare(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfcMifare, (handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUser
    {
    public:
        nn::Result InitializeNfcMifare(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
        nn::Result FinalizeNfcMifare() NN_NOEXCEPT;
        nn::Result ListDevicesNfcMifare(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result StartDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result StopDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result ReadNfcMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
        nn::Result WriteNfcMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
        nn::Result GetTagInfoNfcMifare(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetActivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetDeactivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetStateNfcMifare(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
        nn::Result GetDeviceStateNfcMifare(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetNpadIdNfcMifare(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetAvailabilityChangeEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result InitializeNfcMifare(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfcMifare() NN_NOEXCEPT;
    nn::Result ListDevicesNfcMifare(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result StartDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ReadNfcMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result WriteNfcMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result GetTagInfoNfcMifare(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetStateNfcMifare(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result GetDeviceStateNfcMifare(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadIdNfcMifare(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfc::mifare::detail::IUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfcMifare, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeNfcMifare, (aruid, pid, mcuVersionData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfcMifare)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FinalizeNfcMifare);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDevicesNfcMifare, (devices, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartDetectionNfcMifare, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopDetectionNfcMifare, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadNfcMifare, (blockData, deviceHandle, blockParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteNfcMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteNfcMifare, (deviceHandle, blockParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfcMifare, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTagInfoNfcMifare, (tagInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActivateEventHandleNfcMifare, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeactivateEventHandleNfcMifare, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateNfcMifare, (state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceStateNfcMifare, (state, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfcMifare, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadIdNfcMifare, (npadId, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfcMifare, (handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfc::mifare::detail::IUser>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfc::mifare::detail::IUser))

    // nn::Result InitializeNfcMifare(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mcuVersionData, 0, (const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (mcuVersionData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuVersionData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeNfcMifare)

    // nn::Result FinalizeNfcMifare() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeNfcMifare)

    // nn::Result ListDevicesNfcMifare(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDevicesNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(devices, 0, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (devices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(devices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDevicesNfcMifare)

    // nn::Result StartDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDetectionNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDetectionNfcMifare)

    // nn::Result StopDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopDetectionNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopDetectionNfcMifare)

    // nn::Result ReadNfcMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockData, 0, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockParameter, 1, (const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (blockData, blockParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadNfcMifare)

    // nn::Result WriteNfcMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockParameter, 0, (const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (blockParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteNfcMifare)

    // nn::Result GetTagInfoNfcMifare(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTagInfoNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(tagInfo, 0, (::nn::sf::Out<::nn::nfc::TagInfo>), 88, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (tagInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tagInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTagInfoNfcMifare)

    // nn::Result GetActivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActivateEventHandleNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActivateEventHandleNfcMifare)

    // nn::Result GetDeactivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeactivateEventHandleNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeactivateEventHandleNfcMifare)

    // nn::Result GetStateNfcMifare(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateNfcMifare)

    // nn::Result GetDeviceStateNfcMifare(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceStateNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceStateNfcMifare)

    // nn::Result GetNpadIdNfcMifare(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadIdNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(npadId, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (npadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(npadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadIdNfcMifare)

    // nn::Result GetAvailabilityChangeEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailabilityChangeEventHandleNfcMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailabilityChangeEventHandleNfcMifare)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::McuVersionDataForNfc), 32, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::DeviceHandle), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareReadBlockData), 24, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareReadBlockParameter), 24, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareWriteBlockParameter), 40, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::TagInfo), 88, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfc::mifare::detail::IUser, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfc::mifare::detail::IUser))

    // nn::Result InitializeNfcMifare(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfcMifare, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuVersionData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeNfcMifare)
    }

    // nn::Result FinalizeNfcMifare() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfcMifare)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeNfcMifare)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeNfcMifare)
    }

    // nn::Result ListDevicesNfcMifare(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevicesNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDevicesNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(devices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDevicesNfcMifare)
    }

    // nn::Result StartDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDetectionNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDetectionNfcMifare)
    }

    // nn::Result StopDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetectionNfcMifare, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopDetectionNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopDetectionNfcMifare)
    }

    // nn::Result ReadNfcMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadNfcMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadNfcMifare)
    }

    // nn::Result WriteNfcMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteNfcMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteNfcMifare)
    }

    // nn::Result GetTagInfoNfcMifare(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfoNfcMifare, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTagInfoNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tagInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTagInfoNfcMifare)
    }

    // nn::Result GetActivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActivateEventHandleNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActivateEventHandleNfcMifare)
    }

    // nn::Result GetDeactivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeactivateEventHandleNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeactivateEventHandleNfcMifare)
    }

    // nn::Result GetStateNfcMifare(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateNfcMifare)
    }

    // nn::Result GetDeviceStateNfcMifare(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceStateNfcMifare, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceStateNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceStateNfcMifare)
    }

    // nn::Result GetNpadIdNfcMifare(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIdNfcMifare, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadIdNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(npadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadIdNfcMifare)
    }

    // nn::Result GetAvailabilityChangeEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandleNfcMifare, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailabilityChangeEventHandleNfcMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailabilityChangeEventHandleNfcMifare)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfc::mifare::detail::IUser>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfc::mifare::detail::IUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mcuVersionData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mcuVersionData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDevicesNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(devices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDevicesNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(devices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDetectionNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDetectionNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopDetectionNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopDetectionNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTagInfoNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(tagInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTagInfoNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(tagInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActivateEventHandleNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActivateEventHandleNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeactivateEventHandleNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeactivateEventHandleNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceStateNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceStateNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadIdNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadIdNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(npadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailabilityChangeEventHandleNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailabilityChangeEventHandleNfcMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDevicesNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDetectionNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopDetectionNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTagInfoNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActivateEventHandleNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeactivateEventHandleNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceStateNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadIdNfcMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailabilityChangeEventHandleNfcMifare)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfc::mifare::detail::IUser))

namespace nn { namespace nfc { namespace mifare { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUserManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUserManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::mifare::detail::IUser>> pOutUserInterface))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUserManager)

        ::nn::Result CreateUserInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::mifare::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateUserInterface, (pOutUserInterface));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUserManager
    {
    public:
        nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::mifare::detail::IUser>> pOutUserInterface) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::mifare::detail::IUser>> pOutUserInterface) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfc::mifare::detail::IUserManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::mifare::detail::IUser>> pOutUserInterface))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateUserInterface, (pOutUserInterface));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfc::mifare::detail::IUserManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfc::mifare::detail::IUserManager))

    // nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::mifare::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateUserInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutUserInterface, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutUserInterface))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutUserInterface)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateUserInterface)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfc::mifare::detail::IUserManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfc::mifare::detail::IUserManager))

    // nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::mifare::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::mifare::detail::IUser>> pOutUserInterface))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateUserInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutUserInterface)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateUserInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfc::mifare::detail::IUserManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfc::mifare::detail::IUserManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nfc::mifare::detail::IUser>), pOutUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateUserInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutUserInterface, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateUserInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfc::mifare::detail::IUserManager))
