﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      nfc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NFC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NFC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NFC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NFC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nfc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NFC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Trace, 0, format, args)
#define NN_DETAIL_NFC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Trace, 1, format, args)
#define NN_DETAIL_NFC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Trace, 2, format, args)
#define NN_DETAIL_NFC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Trace, 3, format, args)

#define NN_DETAIL_NFC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Info, 0, format, args)
#define NN_DETAIL_NFC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Info, 1, format, args)
#define NN_DETAIL_NFC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Info, 2, format, args)
#define NN_DETAIL_NFC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Info, 3, format, args)

#define NN_DETAIL_NFC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Warn, 0, format, args)
#define NN_DETAIL_NFC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Warn, 1, format, args)
#define NN_DETAIL_NFC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Warn, 2, format, args)
#define NN_DETAIL_NFC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Warn, 3, format, args)

#define NN_DETAIL_NFC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Error, 0, format, args)
#define NN_DETAIL_NFC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Error, 1, format, args)
#define NN_DETAIL_NFC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Error, 2, format, args)
#define NN_DETAIL_NFC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Error, 3, format, args)

#define NN_DETAIL_NFC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Fatal, 0, format, args)
#define NN_DETAIL_NFC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Fatal, 1, format, args)
#define NN_DETAIL_NFC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Fatal, 2, format, args)
#define NN_DETAIL_NFC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nfc, Fatal, 3, format, args)

#define NN_DETAIL_NFC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Trace, 0, text, length)
#define NN_DETAIL_NFC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Trace, 1, text, length)
#define NN_DETAIL_NFC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Trace, 2, text, length)
#define NN_DETAIL_NFC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Trace, 3, text, length)

#define NN_DETAIL_NFC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Info, 0, text, length)
#define NN_DETAIL_NFC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Info, 1, text, length)
#define NN_DETAIL_NFC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Info, 2, text, length)
#define NN_DETAIL_NFC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Info, 3, text, length)

#define NN_DETAIL_NFC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Warn, 0, text, length)
#define NN_DETAIL_NFC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Warn, 1, text, length)
#define NN_DETAIL_NFC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Warn, 2, text, length)
#define NN_DETAIL_NFC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Warn, 3, text, length)

#define NN_DETAIL_NFC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Error, 0, text, length)
#define NN_DETAIL_NFC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Error, 1, text, length)
#define NN_DETAIL_NFC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Error, 2, text, length)
#define NN_DETAIL_NFC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Error, 3, text, length)

#define NN_DETAIL_NFC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Fatal, 0, text, length)
#define NN_DETAIL_NFC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Fatal, 1, text, length)
#define NN_DETAIL_NFC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Fatal, 2, text, length)
#define NN_DETAIL_NFC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nfc, Fatal, 3, text, length)
