﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/news_TypesAdmin.h>

namespace nn { namespace news {

namespace detail { namespace ipc {

class INewsDataService;

}}

/*!
    @brief      ニュースデータを扱うクラスです。
*/
class Data
{
private:
    NN_DISALLOW_COPY(Data);
    NN_DISALLOW_MOVE(Data);

public:
    /*!
        @brief      コンストラクタです。
    */
    Data() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~Data() NN_NOEXCEPT;

    /*!
        @brief      ニュースデータを開きます。

        @param[in]  name    データ名。

        @return     処理結果。

        @pre
            - name != nullptr
            - 0 < strlen(name) <= @ref DataNameLengthMax
    */
    nn::Result Open(const char* name) NN_NOEXCEPT;

    /*!
        @brief      ニュースデータを開きます。

        @param[in]  record  ニュースレコード。

        @return     処理結果。
    */
    nn::Result Open(const NewsRecord& record) NN_NOEXCEPT;

    /*!
        @brief      ニュースデータを閉じます。
    */
    void Close() NN_NOEXCEPT;

    /*!
        @brief      ニュースデータを読み込みます。

        @param[out] outSize 読み込んだサイズ。
        @param[in]  offset  先頭からのオフセット。
        @param[in]  buffer  読み込みバッファ。
        @param[in]  size    読み込みバッファのサイズ。

        @return     処理結果。

        @pre
            - outSize != nullptr
            - offset >= 0
            - buffer != nullptr
            - size > 0
            - ニュースデータを開いている状態である。
    */
    nn::Result Read(size_t* outSize, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      データサイズを取得します。

        @param[out] outSize データサイズ。

        @return     処理結果。

        @pre
            - outSize != nullptr
            - ニュースデータを開いている状態である。
    */
    nn::Result GetSize(int64_t* outSize) NN_NOEXCEPT;

private:
    //
    detail::ipc::INewsDataService* m_Handle;
};

}}
