﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

namespace nn { namespace news { namespace detail { namespace service { namespace util {

/*!
    @brief      乱数を取得します。

    @return     0 <= x <= UINT64_MAX の範囲内の乱数。
*/
inline uint64_t GetRandom() NN_NOEXCEPT
{
    uint64_t value;
    nn::os::GenerateRandomBytes(&value, sizeof (value));

    return value;
}

/*!
    @brief      範囲を指定して乱数を取得します。

    @param[in]  begin   範囲の先頭。
    @param[in]  end     範囲の終端。

    @return     begin <= x < end の範囲内の乱数。

    @pre
        - begin < end
*/
inline int64_t GetRandom(int64_t begin, int64_t end) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(begin < end);

    uint64_t value;
    nn::os::GenerateRandomBytes(&value, sizeof (value));

    return begin + static_cast<int64_t>(value % (end - begin));
}

}}}}}
