﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_INewsService.sfdl.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      ニュースサービスです。
*/
class NewsServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    NewsServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NewsServiceForGeneric() NN_NOEXCEPT;

public:
    //  INewsService
    nn::Result PostLocalNews(const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT;
    nn::Result GetSubscriptionStatus(nn::sf::Out<std::int32_t> outStatus, const nn::sf::InArray<char>& topicIdString) NN_NOEXCEPT;
    nn::Result GetTopicList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::news::TopicId>& outTopicIds, std::int32_t filter) NN_NOEXCEPT;
    nn::Result IsSystemUpdateRequired(nn::sf::Out<bool> outIsRequired) NN_NOEXCEPT;
    nn::Result RequestImmediateReception(const nn::sf::InArray<char>& topicIdString) NN_NOEXCEPT;
    nn::Result DecodeArchiveFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& decoded, const nn::sf::InBuffer& encoded) NN_NOEXCEPT;
    nn::Result SetSubscriptionStatus(const nn::sf::InArray<char>& topicIdString, std::int32_t status) NN_NOEXCEPT;
    nn::Result RequestAutoSubscription(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ClearStorage() NN_NOEXCEPT;
    nn::Result ClearSubscriptionStatusAll() NN_NOEXCEPT;
    nn::Result GetNewsDatabaseDump(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
};

}}}}
