﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <algorithm>
#include <atomic>
#include <cstdio>
#include <cstring>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/nn_ApplicationId.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/fs.h>
#include <nn/time.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/account.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_Result.h>
#include <nn/bgtc.h>
#include <nn/bgtc/bgtc_Task.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_LockGuard.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Uuid.h>
#include <nn/msgpack.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/news/detail/news_Log.h>

#include <nn/news/news_Result.h>
#include <nn/news/news_ResultPrivate.h>

#include <nn/news/news_Types.h>
#include <nn/news/news_TypesAdmin.h>
#include <nn/news/detail/news_TypesDetail.h>

#include <nn/news/detail/service/core/news_Account.h>
#include <nn/news/detail/service/core/news_FileSystem.h>
#include <nn/news/detail/service/core/news_Path.h>
#include <nn/news/detail/service/core/news_StorageManager.h>
#include <nn/news/detail/service/core/news_StringVerifier.h>
#include <nn/news/detail/service/core/news_Version.h>
#include <nn/news/detail/service/msgpack/news_MsgpackReader.h>
#include <nn/news/detail/service/util/news_Random.h>

// MEMO: socket と nlib を両方 include するとエラーが発生する問題の回避策
#if defined(NN_BUILD_CONFIG_OS_WIN)

#if defined SHUT_RD
#undef SHUT_RD
#endif
#if defined SHUT_WR
#undef SHUT_WR
#endif
#if defined SHUT_RDWR
#undef SHUT_RDWR
#endif

#if defined EDQUOT
#undef EDQUOT
#endif
#if defined ESTALE
#undef ESTALE
#endif

#endif
