﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>
#include <nn/news/detail/service/msgpack/news_MsgpackEventHandler.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニューストピックリストのリーダーです。
*/
class TopicListReader : public detail::service::msgpack::MsgpackEventHandler
{
private:
    NN_DISALLOW_COPY(TopicListReader);
    NN_DISALLOW_MOVE(TopicListReader);

public:
    /*!
        @brief      コンストラクタです。
    */
    TopicListReader() NN_NOEXCEPT;

    /*!
        @brief      トピックリストを読み込みます。

        @param[out] outCount    取得したトピック ID 数。
        @param[out] outTopicIds トピック ID リスト。
        @param[in]  count       トピック ID リストの要素数。
        @param[in]  stream      入力ストリーム。

        @return     処理結果。

        @pre
            - outCount != nullptr
            - outTopicIds != nullptr
            - count > 0
    */
    nn::Result Read(int* outCount, TopicId* outTopicIds, int count, nne::nlib::InputStream& stream) NN_NOEXCEPT;

private:
    //
    TopicId* m_OutTopicIds;
    int m_Index;
    int m_Count;

private:
    // MsgpackEventHandler
    virtual bool OnString(const detail::service::msgpack::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;
};

}}}}}
