﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      文字列データ検証モジュールです。
*/
class StringVerifier
{
public:
    /*!
        @brief      トピック ID を検証します。

        @param[in]  topicId トピック ID。

        @return     妥当なトピック ID かどうか。

        @pre
            - topicId != nullptr
    */
    static bool VerifyTopicId(const char* topicId) NN_NOEXCEPT;

    /*!
        @brief      パスフレーズを検証します。

        @param[in]  passphrase  パスフレーズ。

        @return     妥当なパスフレーズかどうか。

        @pre
            - passphrase != nullptr
    */
    static bool VerifyPassphrase(const char* passphrase) NN_NOEXCEPT;

    /*!
        @brief      ETag を検証します。

        @param[in]  eTag    ETag。

        @return     妥当な ETag かどうか。

        @pre
            - eTag != nullptr
    */
    static bool VerifyETag(const char* eTag) NN_NOEXCEPT;

    /*!
        @brief      データ名を検証します。

        @param[in]  name    データ名。

        @return     妥当なデータ名かどうか。

        @pre
            - name != nullptr
    */
    static bool VerifyDataName(const char* name) NN_NOEXCEPT;

    /*!
        @brief      データベースに登録する文字列値を検証します。

        @param[in]  value   文字列値。

        @return     妥当な文字列値かどうか。

        @pre
            - value != nullptr
    */
    static bool VerifyDatabaseStringValue(const char* value) NN_NOEXCEPT;
};

}}}}}
