﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      パスフレーズ管理モジュールです。
*/
class PassphraseManager
{
private:
    /*!
        @brief      コンストラクタです。
    */
    PassphraseManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static PassphraseManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(PassphraseManager, instance);
        return instance;
    }

public:
    /*!
        @brief      パスフレーズを取得します。

        @param[out] outAppId    アプリケーション ID。
        @param[in]  passphrase  パスフレーズのバッファ。
        @param[in]  size        パスフレーズのバッファサイズ。

        @return     処理結果。

        @pre
            - outAppId != nullptr
            - passphrase != nullptr
            - size >= PassphraseLengthMax + 1
    */
    nn::Result Get(nn::ApplicationId* outAppId, char* passphrase, size_t size) NN_NOEXCEPT;

    /*!
        @brief      パスフレーズを保存します。

        @param[in]  appId       アプリケーション ID。
        @param[in]  passphrase  パスフレーズ。

        @return     処理結果。

        @pre
            - passphrase != nullptr
    */
    nn::Result Save(nn::ApplicationId appId, const char* passphrase) NN_NOEXCEPT;

    /*!
        @brief      パスフレーズをクリアします。

        @return     処理結果。
    */
    nn::Result Clear() NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::ApplicationId m_AppId;
    char m_Passphrase[PassphraseLengthMax + 1];
};

}}}}}
