﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/mmnv/mmnv_Types.h>
#include <nn/nn_Result.h>
#include <nn/os/os_EventCommon.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace mmnv { // NOLINT(whitespace/braces)

class IRequest;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IRequest, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Finalize, (::nn::mmnv::Module moduleId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWait, (::nn::mmnv::Module moduleId, ::std::uint32_t min, ::std::uint32_t max))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint32_t> setting, ::nn::mmnv::Module moduleId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeById, (::nn::sf::Out<::std::int32_t> requestId, ::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeById, (::std::int32_t requestId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWaitById, (::std::int32_t requestId, ::std::uint32_t min, ::std::uint32_t max))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetById, (::nn::sf::Out<::std::uint32_t> setting, ::std::int32_t requestId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IRequest)

        ::nn::Result Initialize(::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (moduleId, priority, eventClearMode));
        }

        ::nn::Result Finalize(::nn::mmnv::Module moduleId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Finalize, (moduleId));
        }

        ::nn::Result SetAndWait(::nn::mmnv::Module moduleId, ::std::uint32_t min, ::std::uint32_t max) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAndWait, (moduleId, min, max));
        }

        ::nn::Result Get(::nn::sf::Out<::std::uint32_t> setting, ::nn::mmnv::Module moduleId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get, (setting, moduleId));
        }

        ::nn::Result InitializeById(::nn::sf::Out<::std::int32_t> requestId, ::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeById, (requestId, moduleId, priority, eventClearMode));
        }

        ::nn::Result FinalizeById(::std::int32_t requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinalizeById, (requestId));
        }

        ::nn::Result SetAndWaitById(::std::int32_t requestId, ::std::uint32_t min, ::std::uint32_t max) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAndWaitById, (requestId, min, max));
        }

        ::nn::Result GetById(::nn::sf::Out<::std::uint32_t> setting, ::std::int32_t requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetById, (setting, requestId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IRequest
    {
    public:
        nn::Result Initialize(nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
        nn::Result Finalize(nn::mmnv::Module moduleId) NN_NOEXCEPT;
        nn::Result SetAndWait(nn::mmnv::Module moduleId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
        nn::Result Get(nn::sf::Out<std::uint32_t> setting, nn::mmnv::Module moduleId) NN_NOEXCEPT;
        nn::Result InitializeById(nn::sf::Out<std::int32_t> requestId, nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
        nn::Result FinalizeById(std::int32_t requestId) NN_NOEXCEPT;
        nn::Result SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
        nn::Result GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize(nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    nn::Result Finalize(nn::mmnv::Module moduleId) NN_NOEXCEPT;
    nn::Result SetAndWait(nn::mmnv::Module moduleId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
    nn::Result Get(nn::sf::Out<std::uint32_t> setting, nn::mmnv::Module moduleId) NN_NOEXCEPT;
    nn::Result InitializeById(nn::sf::Out<std::int32_t> requestId, nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    nn::Result FinalizeById(std::int32_t requestId) NN_NOEXCEPT;
    nn::Result SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
    nn::Result GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::mmnv::IRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (moduleId, priority, eventClearMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Finalize, (::nn::mmnv::Module moduleId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Finalize, (moduleId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWait, (::nn::mmnv::Module moduleId, ::std::uint32_t min, ::std::uint32_t max))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAndWait, (moduleId, min, max));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint32_t> setting, ::nn::mmnv::Module moduleId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get, (setting, moduleId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeById, (::nn::sf::Out<::std::int32_t> requestId, ::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeById, (requestId, moduleId, priority, eventClearMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeById, (::std::int32_t requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinalizeById, (requestId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWaitById, (::std::int32_t requestId, ::std::uint32_t min, ::std::uint32_t max))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAndWaitById, (requestId, min, max));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetById, (::nn::sf::Out<::std::uint32_t> setting, ::std::int32_t requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetById, (setting, requestId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::mmnv::IRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::mmnv::IRequest))

    // nn::Result Initialize(nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::mmnv::Module), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(priority, (::nn::mmnv::Priority), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventClearMode, (::nn::os::EventClearMode), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (moduleId, priority, eventClearMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(priority), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventClearMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Finalize(nn::mmnv::Module moduleId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::mmnv::Module), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    // nn::Result SetAndWait(nn::mmnv::Module moduleId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAndWait)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::mmnv::Module), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(min, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(max, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (moduleId, min, max))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(min), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(max)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAndWait)

    // nn::Result Get(nn::sf::Out<std::uint32_t> setting, nn::mmnv::Module moduleId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::mmnv::Module), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(setting, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (setting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(setting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get)

    // nn::Result InitializeById(nn::sf::Out<std::int32_t> requestId, nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeById)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::mmnv::Module), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(priority, (::nn::mmnv::Priority), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventClearMode, (::nn::os::EventClearMode), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (moduleId, priority, eventClearMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(requestId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(priority), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventClearMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeById)

    // nn::Result FinalizeById(std::int32_t requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeById)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeById)

    // nn::Result SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAndWaitById)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(min, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(max, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (requestId, min, max))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(min), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(max)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAndWaitById)

    // nn::Result GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetById)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(setting, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (setting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(setting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetById)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mmnv::Module), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mmnv::Priority), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::os::EventClearMode), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::mmnv::IRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::mmnv::IRequest))

    // nn::Result Initialize(nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(priority)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventClearMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Finalize(nn::mmnv::Module moduleId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Finalize, (::nn::mmnv::Module moduleId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

    // nn::Result SetAndWait(nn::mmnv::Module moduleId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWait, (::nn::mmnv::Module moduleId, ::std::uint32_t min, ::std::uint32_t max))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAndWait)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(min)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(max)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAndWait)
    }

    // nn::Result Get(nn::sf::Out<std::uint32_t> setting, nn::mmnv::Module moduleId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint32_t> setting, ::nn::mmnv::Module moduleId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(setting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get)
    }

    // nn::Result InitializeById(nn::sf::Out<std::int32_t> requestId, nn::mmnv::Module moduleId, nn::mmnv::Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeById, (::nn::sf::Out<::std::int32_t> requestId, ::nn::mmnv::Module moduleId, ::nn::mmnv::Priority priority, ::nn::os::EventClearMode eventClearMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeById)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(priority)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventClearMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeById)
    }

    // nn::Result FinalizeById(std::int32_t requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeById, (::std::int32_t requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeById)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeById)
    }

    // nn::Result SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAndWaitById, (::std::int32_t requestId, ::std::uint32_t min, ::std::uint32_t max))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAndWaitById)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(min)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(max)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAndWaitById)
    }

    // nn::Result GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetById, (::nn::sf::Out<::std::uint32_t> setting, ::std::int32_t requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetById)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(setting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetById)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::mmnv::IRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::mmnv::IRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(priority),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventClearMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAndWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAndWait)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(min),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(max)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(setting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeById)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(requestId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(priority),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventClearMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeById)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAndWaitById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAndWaitById)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(min),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(max)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetById)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(setting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAndWait)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAndWaitById)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetById)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::mmnv::IRequest))
