﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#define NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC   0
#define NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC  1

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#define NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#else
#define NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
#endif

#define NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL    NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT


// ServiceProvider を別プロセスで駆動するか、同一プロセスの別スレッドで駆動するか
#define NN_DETAIL_MII_CONFIG_SERVER_MODEL_PROCESS  0
#define NN_DETAIL_MII_CONFIG_SERVER_MODEL_THREAD   1

#if defined(NN_BUILD_CONFIG_OS_HORIZON) && NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#define NN_DETAIL_MII_CONFIG_SERVER_MODEL   NN_DETAIL_MII_CONFIG_SERVER_MODEL_PROCESS
#else
#define NN_DETAIL_MII_CONFIG_SERVER_MODEL   NN_DETAIL_MII_CONFIG_SERVER_MODEL_THREAD
#endif
