﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
/**
 * @brief   ログの出力先を定義する列挙体。
 *
 */

namespace nn { namespace lm {

enum LogDestination
{
        LogDestination_TargetManager = (1 << 0),  //!< TargetManager に出力
        LogDestination_Uart          = (1 << 1),  //!< UART に出力
        LogDestination_UartIfSleep   = (1 << 2),  //!< スリープ時には UART に出力

        LogDestination_All  = 0xFFFF,
};

}}
