﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの VR モード向けの本体設定アクセス機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {

/**
 * @brief 現在の VR モード中の輝度設定値を設定します。
 *
 * @param[in]   brightnessSetting   設定する輝度設定値
 * @pre         初期化されている必要があります。
 *              @a brightnessSetting >= 0 である必要があります。
 * @post        @a brightnessSetting が現在使用する輝度設定値になります。
 * @details     現在の VR モード中の輝度設定値を設定します。
 */
void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT;

/**
 * @brief 現在の VR モード中の輝度設定値を取得します。
 *
 * @return      現在の輝度設定値を返します。
 * @pre         初期化されている必要があります。
 * @details     現在の VR モード中の輝度設定値を取得します。
 */
float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT;

} // lbl
} // nn


