﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの本体設定のセーブ・ロード機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace impl {

/**
 * @brief 現在の設定値をNANDに保存します。
 *
 * @pre         初期化されている必要があります。
 * @details     現在の設定値をNANDに保存します。
 */
void SaveCurrentSetting() NN_NOEXCEPT;

/**
 * @brief 設定値をNANDから読み出して、現在の値として設定します。
 *
 * @pre         初期化されている必要があります。
 * @post        現在使用している設定値がNANDに保存されている値になります。
 * @details     設定値をNANDから読み出して、現在の値として設定します。
 */
void LoadCurrentSetting() NN_NOEXCEPT;

} // impl
} // lbl
} // nn


