﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Web 認証アプレットの起動時引数の受け渡しをおこなうクラス
 */

#pragma once

#include <nn/la/la_NifmToWifiWebAuthArguments.h>

#include <nn/applet/applet.h>


namespace nn { namespace la {

/**
 * @brief   Web 認証アプレットの起動時引数の受け渡しをおこなうクラスです。
 *          NIFM の Shim レイヤで利用されます。
 */
class NifmToWifiWebAuthArgumentsWriter
{
private:
    NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_ARGUMENTS_DATA_TYPE m_NifmToWifiWebAuthArgumentsData;

public:
    /**
     * @brief   Web 認証アプレットの起動時引数を構築するコンストラクタです。
     *
     * @param[in]   pAuthUrl       認証のためにアクセスする必要がある URL を指定します。
     * @param[in]   pConnTestUrl   疎通確認のためにアクセスする必要がある URL を指定します。
     * @param[in]   profileId      利用要求提出時に必要とされる接続設定 ID を指定します。
     * @param[in]   submitId       利用要求提出番号を指定します。
     *
     * @details
     */
    NifmToWifiWebAuthArgumentsWriter(const char* pAuthUrl, const char* pConnTestUrl, const nn::util::Uuid& profileId, uint32_t submitId) NN_NOEXCEPT;

    /**
     * @brief   デストラクタです。
     *
     * @details
     */
    ~NifmToWifiWebAuthArgumentsWriter() NN_NOEXCEPT;

    /**
     * @brief   必要パラメータを一つのストレージにまとめ、ライブラリアプレットの入力チャンネルに push します。
     *
     * @param[in]   libraryAppletHandle     対象のライブラリアプレットのハンドルを指定します。
     *
     * @details
     */
    void PushToInChannel(nn::applet::LibraryAppletHandle libraryAppletHandle) const NN_NOEXCEPT;


    /**
     * @internal
     *
     * @brief   Export() で共通引数を出力するのに必要なサイズを取得します。
     *
     * @return  Export() で共通引数を出力するのに必要なサイズが返ります。
     *
     * @details
     *  この関数が返す値は、ライブラリの更新で増加することがあることに注意してください。
     */
    size_t GetExportSize() const NN_NOEXCEPT;

    /**
     * @internal
     *
     * @brief   共通引数をバッファにエクスポートします。
     *
     * @details
     *  この関数は、システムプロセス内で構築した共通引数を、アプリケーションのシムレイヤに引き渡すために使用します。
     */
    void Export(char buffer[], size_t size) const NN_NOEXCEPT;
};

}} // namespace nn::la

