﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      idle モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_IDLE_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(idle, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_IDLE_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(idle, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_IDLE_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(idle, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(idle, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_IDLE_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(idle, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_IDLE_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(idle, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_IDLE_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(idle, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_IDLE_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Trace, 0, format, args)
#define NN_DETAIL_IDLE_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Trace, 1, format, args)
#define NN_DETAIL_IDLE_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Trace, 2, format, args)
#define NN_DETAIL_IDLE_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Trace, 3, format, args)

#define NN_DETAIL_IDLE_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Info, 0, format, args)
#define NN_DETAIL_IDLE_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Info, 1, format, args)
#define NN_DETAIL_IDLE_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Info, 2, format, args)
#define NN_DETAIL_IDLE_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Info, 3, format, args)

#define NN_DETAIL_IDLE_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Warn, 0, format, args)
#define NN_DETAIL_IDLE_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Warn, 1, format, args)
#define NN_DETAIL_IDLE_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Warn, 2, format, args)
#define NN_DETAIL_IDLE_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Warn, 3, format, args)

#define NN_DETAIL_IDLE_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Error, 0, format, args)
#define NN_DETAIL_IDLE_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Error, 1, format, args)
#define NN_DETAIL_IDLE_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Error, 2, format, args)
#define NN_DETAIL_IDLE_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Error, 3, format, args)

#define NN_DETAIL_IDLE_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Fatal, 0, format, args)
#define NN_DETAIL_IDLE_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Fatal, 1, format, args)
#define NN_DETAIL_IDLE_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Fatal, 2, format, args)
#define NN_DETAIL_IDLE_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(idle, Fatal, 3, format, args)

#define NN_DETAIL_IDLE_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(idle, Trace, 0, text, length)
#define NN_DETAIL_IDLE_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Trace, 1, text, length)
#define NN_DETAIL_IDLE_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Trace, 2, text, length)
#define NN_DETAIL_IDLE_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Trace, 3, text, length)

#define NN_DETAIL_IDLE_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(idle, Info, 0, text, length)
#define NN_DETAIL_IDLE_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Info, 1, text, length)
#define NN_DETAIL_IDLE_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Info, 2, text, length)
#define NN_DETAIL_IDLE_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Info, 3, text, length)

#define NN_DETAIL_IDLE_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(idle, Warn, 0, text, length)
#define NN_DETAIL_IDLE_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Warn, 1, text, length)
#define NN_DETAIL_IDLE_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Warn, 2, text, length)
#define NN_DETAIL_IDLE_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(idle, Warn, 3, text, length)

#define NN_DETAIL_IDLE_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(idle, Error, 0, text, length)
#define NN_DETAIL_IDLE_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Error, 1, text, length)
#define NN_DETAIL_IDLE_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Error, 2, text, length)
#define NN_DETAIL_IDLE_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Error, 3, text, length)

#define NN_DETAIL_IDLE_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(idle, Fatal, 0, text, length)
#define NN_DETAIL_IDLE_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Fatal, 1, text, length)
#define NN_DETAIL_IDLE_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Fatal, 2, text, length)
#define NN_DETAIL_IDLE_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(idle, Fatal, 3, text, length)
