﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>

#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/i2c/i2c_IManager.sfdl.h>
#include <nn/i2c/i2c_ISession.sfdl.h>

namespace nn { namespace i2c { namespace server {

// IManager 実装クラス
class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;

    // [GEN1] TODO: Deprecate
    nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession,
                                 std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t device) NN_NOEXCEPT;

    // [GEN1] NOT SUPPORTED
    // [GEN2] NOT SUPPORTED
    nn::Result HasDevice(nn::sf::Out<bool> hasDevice, std::int32_t device) NN_NOEXCEPT;
    nn::Result HasDeviceForDev(nn::sf::Out<bool> hasDevice,
                               std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;

    // [Gen2]
    nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, nn::detail::DeviceCodeType name) NN_NOEXCEPT;

private:

    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;
};

}}}
