﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   I2C ライブラリの定数・列挙体の定義
 */

#pragma once

namespace nn {
namespace i2c {

/**
 * @brief I2Cトランザクションのオプションパラメータ
 */
enum TransactionOption
{
    TransactionOption_StartCondition   = (1u <<  0),  //!< トランザクション開始時に Start condition を送信します。
    TransactionOption_StopCondition    = (1u <<  1),  //!< トランザクション終了時に Stop condition を送信します。
    TransactionOption_MaxBits          = (1u << 30)   //!< enumのサイズを間接的に指定するためのダミーエントリです。
};

/**
 * @brief　　　　　　　アドレスモード
 * @details　　　　　7bit アドレスモードのみサポートされます。
 */
enum AddressingMode
{
    AddressingMode_BitWidth7    //!< 7 bit address mode
};

/**
 * @brief         動作速度
 * @details       サポートされる動作速度が定義されます。
 */
enum SpeedMode
{
    SpeedMode_Standard  = 100000,   //!< Standard-mode 100 kbps
    SpeedMode_Fast      = 400000,   //!< Fast-mode 400 kbps
    SpeedMode_FastPlus  = 1000000, //!< Fast-mode Plus 1 Mbps
    SpeedMode_HighSpeed = 3400000  //!< High-speed mode 3.4 Mbps
};

} // i2c
} // nn


