﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

#include <nn/ddsf/ddsf_IDevice.h>
#include <nn/i2c/i2c_Type.h>

namespace nn { namespace i2c { namespace driver {

class II2cDriver;

class I2cDeviceProperty : public nn::ddsf::IDevice
{
    NN_DDSF_CAST_SAFE_DECL;

    NN_DISALLOW_COPY(I2cDeviceProperty);
    NN_DISALLOW_MOVE(I2cDeviceProperty);

public:

    /**
     * @brief   デフォルトコンストラクタです。
     */
    I2cDeviceProperty() NN_NOEXCEPT
        : m_Address(0)
        , m_AddressingMode(AddressingMode_BitWidth7)
    {}

    I2cDeviceProperty(Bit16 address, AddressingMode addressingMode) NN_NOEXCEPT
        : m_Address(address)
        , m_AddressingMode(addressingMode)
    {}

    /**
     * @brief   デストラクタです。
     */
    virtual ~I2cDeviceProperty() NN_NOEXCEPT {}

    /**
     * @brief デバイスのスレーブアドレスを取得します。
     */
    nn::Bit16 GetAddress() const NN_NOEXCEPT
    {
        return m_Address;
    }

    /**
     * @brief デバイスのアドレスモードを取得します。
     */
    AddressingMode GetAddressingMode() const NN_NOEXCEPT
    {
        return m_AddressingMode;
    }

private:
    Bit16 m_Address;
    AddressingMode m_AddressingMode;
};

}}} // nn::i2c::driver
