﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/http/http_Response.h>

#undef EDQUOT
#include <nn/msgpack.h>

namespace nn
{
namespace http
{

class JsonResponse : public Response
{
    NN_DISALLOW_COPY(JsonResponse);
    NN_DISALLOW_MOVE(JsonResponse);
public:
    enum ValueType
    {
        ValueType_Int64,
        ValueType_Uint64,
        ValueType_String,
        ValueType_Int64Force
    };
    struct ParseRule
    {
        const char* pKeyName;
        const char* pParentKeyName; // not implemented
        ValueType expectedValueType;
        void* pStorage;
        size_t sizeStorage;
    };
//    typedef bool (*TokenHandler)(msgpack::JsonStreamParser& parser, msgpack::JsonStreamParser::Event event);
    typedef std::function<bool(msgpack::JsonStreamParser& parser, msgpack::JsonStreamParser::Event event)> TokenHandler;

    JsonResponse(void* pWorkBuffer, size_t sizeWorkBuffer);
    virtual ~JsonResponse();

    Result ReadAndParse(TokenHandler tokenHandler);
    Result ReadAndParseWithRule(const ParseRule pRulesArray[]);

private:
    using Response::ReadBody;

    void* m_pWorkBuffer;
    size_t m_sizeWorkBuffer;
};

}
}
