﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/vi/sf/hosbinder_IHOSBinderDriver.sfdl.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

struct ContinuousRecordingFlushParameter;

struct ContinuousRecordingParameter;

struct GameMovieId;

class IContinuousRecorder;

class IGameMovieTrimmer;

class IGrcService;

class IMovieMaker;

class IMovieMakerService;

class IOffscreenRecorder;

struct OffscreenRecordingParameter;

struct ContinuousRecordingFlushParameter
{
    nn::Bit8 data[64];
};

struct ContinuousRecordingParameter
{
    nn::Bit32 data[16];
};

struct GameMovieId
{
    nn::Bit64 data[8];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IContinuousRecorder, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IContinuousRecorder)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartRecording)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopRecording)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNotFlushingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartFlush, (const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelFlush)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetFlushTime, (::std::int64_t additionalTimeNs))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartFlushWithEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IContinuousRecorder)

        ::nn::Result StartRecording() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartRecording);
        }

        ::nn::Result StopRecording() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopRecording);
        }

        ::nn::Result GetNotFlushingEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNotFlushingEvent, (pOutSystemEventHandle));
        }

        ::nn::Result StartFlush(const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartFlush, (flushParameter));
        }

        ::nn::Result CancelFlush() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelFlush);
        }

        ::nn::Result ResetFlushTime(::std::int64_t additionalTimeNs) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetFlushTime, (additionalTimeNs));
        }

        ::nn::Result StartFlushWithEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOut, const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartFlushWithEvent, (pOut, flushParameter));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IContinuousRecorder
    {
    public:
        nn::Result StartRecording() NN_NOEXCEPT;
        nn::Result StopRecording() NN_NOEXCEPT;
        nn::Result GetNotFlushingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
        nn::Result StartFlush(const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT;
        nn::Result CancelFlush() NN_NOEXCEPT;
        nn::Result ResetFlushTime(std::int64_t additionalTimeNs) NN_NOEXCEPT;
        nn::Result StartFlushWithEvent(nn::sf::Out<nn::sf::NativeHandle> pOut, const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result StartRecording() NN_NOEXCEPT;
    nn::Result StopRecording() NN_NOEXCEPT;
    nn::Result GetNotFlushingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    nn::Result StartFlush(const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT;
    nn::Result CancelFlush() NN_NOEXCEPT;
    nn::Result ResetFlushTime(std::int64_t additionalTimeNs) NN_NOEXCEPT;
    nn::Result StartFlushWithEvent(nn::sf::Out<nn::sf::NativeHandle> pOut, const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IContinuousRecorder))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartRecording)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartRecording);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopRecording)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopRecording);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNotFlushingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNotFlushingEvent, (pOutSystemEventHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFlush, (const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartFlush, (flushParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelFlush)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelFlush);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetFlushTime, (::std::int64_t additionalTimeNs))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetFlushTime, (additionalTimeNs));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFlushWithEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartFlushWithEvent, (pOut, flushParameter));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IContinuousRecorder>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IContinuousRecorder))

    // nn::Result StartRecording() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartRecording)

    // nn::Result StopRecording() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopRecording)

    // nn::Result GetNotFlushingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNotFlushingEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutSystemEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutSystemEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemEventHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNotFlushingEvent)

    // nn::Result StartFlush(const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartFlush)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flushParameter, (::nn::grcsrv::ContinuousRecordingFlushParameter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flushParameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flushParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartFlush)

    // nn::Result CancelFlush() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelFlush)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelFlush)

    // nn::Result ResetFlushTime(std::int64_t additionalTimeNs) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetFlushTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(additionalTimeNs, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (additionalTimeNs))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(additionalTimeNs)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetFlushTime)

    // nn::Result StartFlushWithEvent(nn::sf::Out<nn::sf::NativeHandle> pOut, const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartFlushWithEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flushParameter, (::nn::grcsrv::ContinuousRecordingFlushParameter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flushParameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flushParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartFlushWithEvent)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IContinuousRecorder, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IContinuousRecorder))

    // nn::Result StartRecording() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartRecording)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartRecording)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartRecording)
    }

    // nn::Result StopRecording() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopRecording)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopRecording)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopRecording)
    }

    // nn::Result GetNotFlushingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNotFlushingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNotFlushingEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemEventHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNotFlushingEvent)
    }

    // nn::Result StartFlush(const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFlush, (const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartFlush)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flushParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartFlush)
    }

    // nn::Result CancelFlush() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelFlush)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelFlush)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelFlush)
    }

    // nn::Result ResetFlushTime(std::int64_t additionalTimeNs) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetFlushTime, (::std::int64_t additionalTimeNs))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetFlushTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(additionalTimeNs)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetFlushTime)
    }

    // nn::Result StartFlushWithEvent(nn::sf::Out<nn::sf::NativeHandle> pOut, const nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFlushWithEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, const ::nn::grcsrv::ContinuousRecordingFlushParameter& flushParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartFlushWithEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flushParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartFlushWithEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IContinuousRecorder>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IContinuousRecorder))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNotFlushingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutSystemEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNotFlushingEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutSystemEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartFlush)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartFlush)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flushParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelFlush)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelFlush)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetFlushTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetFlushTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(additionalTimeNs)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartFlushWithEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartFlushWithEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flushParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNotFlushingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartFlush)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelFlush)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetFlushTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartFlushWithEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IContinuousRecorder))

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGameMovieTrimmer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGameMovieTrimmer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BeginTrim, (const ::nn::grcsrv::GameMovieId& id, ::std::int32_t beginIndex, ::std::int32_t endIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EndTrim, (::nn::sf::Out<::nn::grcsrv::GameMovieId> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNotTrimmingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetThumbnailRgba, (const ::nn::sf::InBuffer& imageData, ::std::int32_t width, ::std::int32_t height))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGameMovieTrimmer)

        ::nn::Result BeginTrim(const ::nn::grcsrv::GameMovieId& id, ::std::int32_t beginIndex, ::std::int32_t endIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BeginTrim, (id, beginIndex, endIndex));
        }

        ::nn::Result EndTrim(::nn::sf::Out<::nn::grcsrv::GameMovieId> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EndTrim, (pOut));
        }

        ::nn::Result GetNotTrimmingEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNotTrimmingEvent, (pOutSystemEventHandle));
        }

        ::nn::Result SetThumbnailRgba(const ::nn::sf::InBuffer& imageData, ::std::int32_t width, ::std::int32_t height) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetThumbnailRgba, (imageData, width, height));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGameMovieTrimmer
    {
    public:
        nn::Result BeginTrim(const nn::grcsrv::GameMovieId& id, std::int32_t beginIndex, std::int32_t endIndex) NN_NOEXCEPT;
        nn::Result EndTrim(nn::sf::Out<nn::grcsrv::GameMovieId> pOut) NN_NOEXCEPT;
        nn::Result GetNotTrimmingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
        nn::Result SetThumbnailRgba(const nn::sf::InBuffer& imageData, std::int32_t width, std::int32_t height) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result BeginTrim(const nn::grcsrv::GameMovieId& id, std::int32_t beginIndex, std::int32_t endIndex) NN_NOEXCEPT;
    nn::Result EndTrim(nn::sf::Out<nn::grcsrv::GameMovieId> pOut) NN_NOEXCEPT;
    nn::Result GetNotTrimmingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    nn::Result SetThumbnailRgba(const nn::sf::InBuffer& imageData, std::int32_t width, std::int32_t height) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IGameMovieTrimmer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginTrim, (const ::nn::grcsrv::GameMovieId& id, ::std::int32_t beginIndex, ::std::int32_t endIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BeginTrim, (id, beginIndex, endIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndTrim, (::nn::sf::Out<::nn::grcsrv::GameMovieId> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EndTrim, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNotTrimmingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNotTrimmingEvent, (pOutSystemEventHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetThumbnailRgba, (const ::nn::sf::InBuffer& imageData, ::std::int32_t width, ::std::int32_t height))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetThumbnailRgba, (imageData, width, height));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IGameMovieTrimmer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IGameMovieTrimmer))

    // nn::Result BeginTrim(const nn::grcsrv::GameMovieId& id, std::int32_t beginIndex, std::int32_t endIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginTrim)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beginIndex, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(endIndex, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::grcsrv::GameMovieId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (beginIndex, endIndex, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beginIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(endIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginTrim)

    // nn::Result EndTrim(nn::sf::Out<nn::grcsrv::GameMovieId> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndTrim)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::grcsrv::GameMovieId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndTrim)

    // nn::Result GetNotTrimmingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNotTrimmingEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutSystemEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutSystemEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemEventHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNotTrimmingEvent)

    // nn::Result SetThumbnailRgba(const nn::sf::InBuffer& imageData, std::int32_t width, std::int32_t height) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetThumbnailRgba)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (width, height))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetThumbnailRgba)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IGameMovieTrimmer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IGameMovieTrimmer))

    // nn::Result BeginTrim(const nn::grcsrv::GameMovieId& id, std::int32_t beginIndex, std::int32_t endIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginTrim, (const ::nn::grcsrv::GameMovieId& id, ::std::int32_t beginIndex, ::std::int32_t endIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginTrim)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beginIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(endIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginTrim)
    }

    // nn::Result EndTrim(nn::sf::Out<nn::grcsrv::GameMovieId> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndTrim, (::nn::sf::Out<::nn::grcsrv::GameMovieId> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndTrim)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndTrim)
    }

    // nn::Result GetNotTrimmingEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNotTrimmingEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNotTrimmingEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemEventHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNotTrimmingEvent)
    }

    // nn::Result SetThumbnailRgba(const nn::sf::InBuffer& imageData, std::int32_t width, std::int32_t height) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetThumbnailRgba, (const ::nn::sf::InBuffer& imageData, ::std::int32_t width, ::std::int32_t height))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetThumbnailRgba)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetThumbnailRgba)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IGameMovieTrimmer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IGameMovieTrimmer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginTrim)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginTrim)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beginIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(endIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndTrim)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndTrim)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNotTrimmingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutSystemEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNotTrimmingEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutSystemEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetThumbnailRgba)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetThumbnailRgba)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginTrim)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndTrim)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNotTrimmingEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetThumbnailRgba)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IGameMovieTrimmer))

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGrcService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGrcService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateContinuousRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IContinuousRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize, const ::nn::grcsrv::ContinuousRecordingParameter& parameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateGameMovieTrimmer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IGameMovieTrimmer>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IOffscreenRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMakerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOffscreenRecorderCheckPointForTesting, (::std::uint64_t value))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGrcService)

        ::nn::Result CreateContinuousRecorder(::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IContinuousRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize, const ::nn::grcsrv::ContinuousRecordingParameter& parameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateContinuousRecorder, (pOut, ::std::move(workMemoryHandle), workMemorySize, parameter));
        }

        ::nn::Result CreateGameMovieTrimmer(::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IGameMovieTrimmer>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateGameMovieTrimmer, (pOut, ::std::move(workMemoryHandle), workMemorySize));
        }

        ::nn::Result CreateOffscreenRecorder(::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IOffscreenRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateOffscreenRecorder, (pOut, ::std::move(workMemoryHandle), workMemorySize));
        }

        ::nn::Result CreateMovieMakerForApplication(::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateMovieMakerForApplication, (outProxy, aruid, applicationId));
        }

        ::nn::Result SetOffscreenRecorderCheckPointForTesting(::std::uint64_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOffscreenRecorderCheckPointForTesting, (value));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGrcService
    {
    public:
        nn::Result CreateContinuousRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IContinuousRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize, const nn::grcsrv::ContinuousRecordingParameter& parameter) NN_NOEXCEPT;
        nn::Result CreateGameMovieTrimmer(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IGameMovieTrimmer>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT;
        nn::Result CreateOffscreenRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IOffscreenRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT;
        nn::Result CreateMovieMakerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result SetOffscreenRecorderCheckPointForTesting(std::uint64_t value) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateContinuousRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IContinuousRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize, const nn::grcsrv::ContinuousRecordingParameter& parameter) NN_NOEXCEPT;
    nn::Result CreateGameMovieTrimmer(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IGameMovieTrimmer>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT;
    nn::Result CreateOffscreenRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IOffscreenRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT;
    nn::Result CreateMovieMakerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result SetOffscreenRecorderCheckPointForTesting(std::uint64_t value) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IGrcService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContinuousRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IContinuousRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize, const ::nn::grcsrv::ContinuousRecordingParameter& parameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateContinuousRecorder, (pOut, ::std::move(workMemoryHandle), workMemorySize, parameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGameMovieTrimmer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IGameMovieTrimmer>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateGameMovieTrimmer, (pOut, ::std::move(workMemoryHandle), workMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IOffscreenRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateOffscreenRecorder, (pOut, ::std::move(workMemoryHandle), workMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMakerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateMovieMakerForApplication, (outProxy, aruid, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOffscreenRecorderCheckPointForTesting, (::std::uint64_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOffscreenRecorderCheckPointForTesting, (value));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IGrcService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IGrcService))

    // nn::Result CreateContinuousRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IContinuousRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize, const nn::grcsrv::ContinuousRecordingParameter& parameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateContinuousRecorder)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameter, (::nn::grcsrv::ContinuousRecordingParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint64_t), 64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (parameter, workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateContinuousRecorder)

    // nn::Result CreateGameMovieTrimmer(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IGameMovieTrimmer>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateGameMovieTrimmer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateGameMovieTrimmer)

    // nn::Result CreateOffscreenRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IOffscreenRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateOffscreenRecorder)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateOffscreenRecorder)

    // nn::Result CreateMovieMakerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateMovieMakerForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outProxy, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outProxy))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProxy), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateMovieMakerForApplication)

    // nn::Result SetOffscreenRecorderCheckPointForTesting(std::uint64_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOffscreenRecorderCheckPointForTesting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9903)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOffscreenRecorderCheckPointForTesting)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IGrcService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IGrcService))

    // nn::Result CreateContinuousRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IContinuousRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize, const nn::grcsrv::ContinuousRecordingParameter& parameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContinuousRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IContinuousRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize, const ::nn::grcsrv::ContinuousRecordingParameter& parameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateContinuousRecorder)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateContinuousRecorder)
    }

    // nn::Result CreateGameMovieTrimmer(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IGameMovieTrimmer>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGameMovieTrimmer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IGameMovieTrimmer>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateGameMovieTrimmer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateGameMovieTrimmer)
    }

    // nn::Result CreateOffscreenRecorder(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IOffscreenRecorder>> pOut, nn::sf::NativeHandle&& workMemoryHandle, std::uint64_t workMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenRecorder, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IOffscreenRecorder>> pOut, ::nn::sf::NativeHandle&& workMemoryHandle, ::std::uint64_t workMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateOffscreenRecorder)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateOffscreenRecorder)
    }

    // nn::Result CreateMovieMakerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMakerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateMovieMakerForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProxy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateMovieMakerForApplication)
    }

    // nn::Result SetOffscreenRecorderCheckPointForTesting(std::uint64_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOffscreenRecorderCheckPointForTesting, (::std::uint64_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOffscreenRecorderCheckPointForTesting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOffscreenRecorderCheckPointForTesting)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IGrcService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IGrcService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateContinuousRecorder)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::grcsrv::IContinuousRecorder>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateContinuousRecorder)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateGameMovieTrimmer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::grcsrv::IGameMovieTrimmer>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateGameMovieTrimmer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateOffscreenRecorder)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::grcsrv::IOffscreenRecorder>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateOffscreenRecorder)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateMovieMakerForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>), outProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateMovieMakerForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outProxy),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outProxy, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOffscreenRecorderCheckPointForTesting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOffscreenRecorderCheckPointForTesting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateContinuousRecorder)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateGameMovieTrimmer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateOffscreenRecorder)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateMovieMakerForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOffscreenRecorderCheckPointForTesting)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IGrcService))

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

struct OffscreenRecordingParameter
{
    nn::Bit64 data[16];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMovieMaker, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMovieMaker)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateVideoProxy, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outProxy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenOffscreenLayer, (::nn::sf::Out<::std::int32_t> outProducerHandle, ::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseOffscreenLayer, (::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecording, (::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AbortOffscreenRecording, (::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestOffscreenRecordingFinishReady, (::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinish, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecordingEx, (::std::uint64_t layerHandle, const ::nn::grcsrv::OffscreenRecordingParameter& paramData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinishEx0, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData, const ::nn::sf::InBuffer& thumbnailImage, ::std::int32_t thumbnailImageWidth, ::std::int32_t thumbnailImageHeight))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerError, (::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EncodeOffscreenLayerAudioSample, (::nn::sf::Out<::std::uint64_t> outEncodedSize, ::std::uint64_t layerHandle, const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerRecordingFinishReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerAudioEncodeReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMovieMaker)

        ::nn::Result CreateVideoProxy(::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateVideoProxy, (outProxy));
        }

        ::nn::Result OpenOffscreenLayer(::nn::sf::Out<::std::int32_t> outProducerHandle, ::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenOffscreenLayer, (outProducerHandle, layerHandle));
        }

        ::nn::Result CloseOffscreenLayer(::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseOffscreenLayer, (layerHandle));
        }

        ::nn::Result StartOffscreenRecording(::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartOffscreenRecording, (layerHandle));
        }

        ::nn::Result AbortOffscreenRecording(::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AbortOffscreenRecording, (layerHandle));
        }

        ::nn::Result RequestOffscreenRecordingFinishReady(::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestOffscreenRecordingFinishReady, (layerHandle));
        }

        ::nn::Result CompleteOffscreenRecordingFinish(::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinish, (layerHandle, userData));
        }

        ::nn::Result StartOffscreenRecordingEx(::std::uint64_t layerHandle, const ::nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartOffscreenRecordingEx, (layerHandle, paramData));
        }

        ::nn::Result CompleteOffscreenRecordingFinishEx0(::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData, const ::nn::sf::InBuffer& thumbnailImage, ::std::int32_t thumbnailImageWidth, ::std::int32_t thumbnailImageHeight) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinishEx0, (layerHandle, userData, thumbnailImage, thumbnailImageWidth, thumbnailImageHeight));
        }

        ::nn::Result GetOffscreenLayerError(::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOffscreenLayerError, (layerHandle));
        }

        ::nn::Result EncodeOffscreenLayerAudioSample(::nn::sf::Out<::std::uint64_t> outEncodedSize, ::std::uint64_t layerHandle, const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EncodeOffscreenLayerAudioSample, (outEncodedSize, layerHandle, buffer));
        }

        ::nn::Result GetOffscreenLayerRecordingFinishReadyEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOffscreenLayerRecordingFinishReadyEvent, (outHandle, layerHandle));
        }

        ::nn::Result GetOffscreenLayerAudioEncodeReadyEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOffscreenLayerAudioEncodeReadyEvent, (outHandle, layerHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMovieMaker
    {
    public:
        nn::Result CreateVideoProxy(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT;
        nn::Result OpenOffscreenLayer(nn::sf::Out<std::int32_t> outProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result StartOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const nn::sf::InBuffer& userData) NN_NOEXCEPT;
        nn::Result StartOffscreenRecordingEx(std::uint64_t layerHandle, const nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT;
        nn::Result CompleteOffscreenRecordingFinishEx0(std::uint64_t layerHandle, const nn::sf::InBuffer& userData, const nn::sf::InBuffer& thumbnailImage, std::int32_t thumbnailImageWidth, std::int32_t thumbnailImageHeight) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateVideoProxy(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT;
    nn::Result OpenOffscreenLayer(nn::sf::Out<std::int32_t> outProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result StartOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const nn::sf::InBuffer& userData) NN_NOEXCEPT;
    nn::Result StartOffscreenRecordingEx(std::uint64_t layerHandle, const nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT;
    nn::Result CompleteOffscreenRecordingFinishEx0(std::uint64_t layerHandle, const nn::sf::InBuffer& userData, const nn::sf::InBuffer& thumbnailImage, std::int32_t thumbnailImageWidth, std::int32_t thumbnailImageHeight) NN_NOEXCEPT;
    nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IMovieMaker))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateVideoProxy, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outProxy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateVideoProxy, (outProxy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenOffscreenLayer, (::nn::sf::Out<::std::int32_t> outProducerHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenOffscreenLayer, (outProducerHandle, layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseOffscreenLayer, (::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseOffscreenLayer, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecording, (::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartOffscreenRecording, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AbortOffscreenRecording, (::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AbortOffscreenRecording, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestOffscreenRecordingFinishReady, (::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestOffscreenRecordingFinishReady, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinish, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompleteOffscreenRecordingFinish, (layerHandle, userData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecordingEx, (::std::uint64_t layerHandle, const ::nn::grcsrv::OffscreenRecordingParameter& paramData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartOffscreenRecordingEx, (layerHandle, paramData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinishEx0, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData, const ::nn::sf::InBuffer& thumbnailImage, ::std::int32_t thumbnailImageWidth, ::std::int32_t thumbnailImageHeight))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompleteOffscreenRecordingFinishEx0, (layerHandle, userData, thumbnailImage, thumbnailImageWidth, thumbnailImageHeight));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerError, (::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOffscreenLayerError, (layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EncodeOffscreenLayerAudioSample, (::nn::sf::Out<::std::uint64_t> outEncodedSize, ::std::uint64_t layerHandle, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EncodeOffscreenLayerAudioSample, (outEncodedSize, layerHandle, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerRecordingFinishReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOffscreenLayerRecordingFinishReadyEvent, (outHandle, layerHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerAudioEncodeReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOffscreenLayerAudioEncodeReadyEvent, (outHandle, layerHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IMovieMaker>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IMovieMaker))

    // nn::Result CreateVideoProxy(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateVideoProxy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outProxy, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outProxy))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProxy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateVideoProxy)

    // nn::Result OpenOffscreenLayer(nn::sf::Out<std::int32_t> outProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenOffscreenLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outProducerHandle, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outProducerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProducerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenOffscreenLayer)

    // nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseOffscreenLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseOffscreenLayer)

    // nn::Result StartOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartOffscreenRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartOffscreenRecording)

    // nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AbortOffscreenRecording)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AbortOffscreenRecording)

    // nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestOffscreenRecordingFinishReady)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestOffscreenRecordingFinishReady)

    // nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const nn::sf::InBuffer& userData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompleteOffscreenRecordingFinish)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(userData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (userData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompleteOffscreenRecordingFinish)

    // nn::Result StartOffscreenRecordingEx(std::uint64_t layerHandle, const nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartOffscreenRecordingEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(paramData, (::nn::grcsrv::OffscreenRecordingParameter), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerHandle, paramData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(136)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(paramData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartOffscreenRecordingEx)

    // nn::Result CompleteOffscreenRecordingFinishEx0(std::uint64_t layerHandle, const nn::sf::InBuffer& userData, const nn::sf::InBuffer& thumbnailImage, std::int32_t thumbnailImageWidth, std::int32_t thumbnailImageHeight) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompleteOffscreenRecordingFinishEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(userData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbnailImage, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (userData, thumbnailImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailImageWidth, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailImageHeight, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (thumbnailImageWidth, thumbnailImageHeight, layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailImage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailImageWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailImageHeight)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompleteOffscreenRecordingFinishEx0)

    // nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOffscreenLayerError)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOffscreenLayerError)

    // nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EncodeOffscreenLayerAudioSample)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEncodedSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEncodedSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEncodedSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EncodeOffscreenLayerAudioSample)

    // nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOffscreenLayerRecordingFinishReadyEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOffscreenLayerRecordingFinishReadyEvent)

    // nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOffscreenLayerAudioEncodeReadyEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (layerHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOffscreenLayerAudioEncodeReadyEvent)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IMovieMaker, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IMovieMaker))

    // nn::Result CreateVideoProxy(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateVideoProxy, (::nn::sf::Out<::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>> outProxy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateVideoProxy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProxy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateVideoProxy)
    }

    // nn::Result OpenOffscreenLayer(nn::sf::Out<std::int32_t> outProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenOffscreenLayer, (::nn::sf::Out<::std::int32_t> outProducerHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenOffscreenLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProducerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenOffscreenLayer)
    }

    // nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseOffscreenLayer, (::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseOffscreenLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseOffscreenLayer)
    }

    // nn::Result StartOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecording, (::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartOffscreenRecording)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartOffscreenRecording)
    }

    // nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AbortOffscreenRecording, (::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AbortOffscreenRecording)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AbortOffscreenRecording)
    }

    // nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestOffscreenRecordingFinishReady, (::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestOffscreenRecordingFinishReady)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestOffscreenRecordingFinishReady)
    }

    // nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const nn::sf::InBuffer& userData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinish, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompleteOffscreenRecordingFinish)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompleteOffscreenRecordingFinish)
    }

    // nn::Result StartOffscreenRecordingEx(std::uint64_t layerHandle, const nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartOffscreenRecordingEx, (::std::uint64_t layerHandle, const ::nn::grcsrv::OffscreenRecordingParameter& paramData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartOffscreenRecordingEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(paramData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartOffscreenRecordingEx)
    }

    // nn::Result CompleteOffscreenRecordingFinishEx0(std::uint64_t layerHandle, const nn::sf::InBuffer& userData, const nn::sf::InBuffer& thumbnailImage, std::int32_t thumbnailImageWidth, std::int32_t thumbnailImageHeight) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteOffscreenRecordingFinishEx0, (::std::uint64_t layerHandle, const ::nn::sf::InBuffer& userData, const ::nn::sf::InBuffer& thumbnailImage, ::std::int32_t thumbnailImageWidth, ::std::int32_t thumbnailImageHeight))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompleteOffscreenRecordingFinishEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailImageWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailImageHeight)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompleteOffscreenRecordingFinishEx0)
    }

    // nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerError, (::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOffscreenLayerError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOffscreenLayerError)
    }

    // nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EncodeOffscreenLayerAudioSample, (::nn::sf::Out<::std::uint64_t> outEncodedSize, ::std::uint64_t layerHandle, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EncodeOffscreenLayerAudioSample)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEncodedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EncodeOffscreenLayerAudioSample)
    }

    // nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerRecordingFinishReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOffscreenLayerRecordingFinishReadyEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOffscreenLayerRecordingFinishReadyEvent)
    }

    // nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, std::uint64_t layerHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOffscreenLayerAudioEncodeReadyEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::std::uint64_t layerHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOffscreenLayerAudioEncodeReadyEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOffscreenLayerAudioEncodeReadyEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IMovieMaker>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IMovieMaker))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateVideoProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nns::hosbinder::IHOSBinderDriver>), outProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateVideoProxy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outProxy, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenOffscreenLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outProducerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseOffscreenLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartOffscreenRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartOffscreenRecording)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AbortOffscreenRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AbortOffscreenRecording)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestOffscreenRecordingFinishReady)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestOffscreenRecordingFinishReady)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompleteOffscreenRecordingFinish)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompleteOffscreenRecordingFinish)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartOffscreenRecordingEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartOffscreenRecordingEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(paramData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompleteOffscreenRecordingFinishEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbnailImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompleteOffscreenRecordingFinishEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbnailImage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailImageWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailImageHeight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOffscreenLayerError)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOffscreenLayerError)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EncodeOffscreenLayerAudioSample)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EncodeOffscreenLayerAudioSample)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEncodedSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOffscreenLayerRecordingFinishReadyEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOffscreenLayerRecordingFinishReadyEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOffscreenLayerAudioEncodeReadyEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOffscreenLayerAudioEncodeReadyEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateVideoProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartOffscreenRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AbortOffscreenRecording)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestOffscreenRecordingFinishReady)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompleteOffscreenRecordingFinish)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartOffscreenRecordingEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompleteOffscreenRecordingFinishEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOffscreenLayerError)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EncodeOffscreenLayerAudioSample)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOffscreenLayerRecordingFinishReadyEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOffscreenLayerAudioEncodeReadyEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IMovieMaker))

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMovieMakerService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMovieMakerService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMaker, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMovieMakerService)

        ::nn::Result CreateMovieMaker(::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateMovieMaker, (outProxy, aruid, applicationId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMovieMakerService
    {
    public:
        nn::Result CreateMovieMaker(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateMovieMaker(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IMovieMakerService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMaker, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateMovieMaker, (outProxy, aruid, applicationId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IMovieMakerService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IMovieMakerService))

    // nn::Result CreateMovieMaker(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateMovieMaker)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outProxy, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outProxy))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProxy), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateMovieMaker)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IMovieMakerService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IMovieMakerService))

    // nn::Result CreateMovieMaker(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMovieMaker, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>> outProxy, ::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateMovieMaker)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProxy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateMovieMaker)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IMovieMakerService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IMovieMakerService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateMovieMaker)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::grcsrv::IMovieMaker>), outProxy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateMovieMaker)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outProxy),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outProxy, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateMovieMaker)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IMovieMakerService))

namespace nn { namespace grcsrv { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IOffscreenRecorder, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IOffscreenRecorder)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenLayer, (::nn::sf::Out<::std::uint64_t> outHandle, ::nn::applet::AppletResourceUserId rendererAruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyOffscreenLayer, (::std::uint64_t handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IOffscreenRecorder)

        ::nn::Result CreateOffscreenLayer(::nn::sf::Out<::std::uint64_t> outHandle, ::nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateOffscreenLayer, (outHandle, rendererAruid));
        }

        ::nn::Result DestroyOffscreenLayer(::std::uint64_t handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyOffscreenLayer, (handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IOffscreenRecorder
    {
    public:
        nn::Result CreateOffscreenLayer(nn::sf::Out<std::uint64_t> outHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT;
        nn::Result DestroyOffscreenLayer(std::uint64_t handle) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateOffscreenLayer(nn::sf::Out<std::uint64_t> outHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT;
    nn::Result DestroyOffscreenLayer(std::uint64_t handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::grcsrv::IOffscreenRecorder))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenLayer, (::nn::sf::Out<::std::uint64_t> outHandle, ::nn::applet::AppletResourceUserId rendererAruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateOffscreenLayer, (outHandle, rendererAruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyOffscreenLayer, (::std::uint64_t handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyOffscreenLayer, (handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::grcsrv::IOffscreenRecorder>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::grcsrv::IOffscreenRecorder))

    // nn::Result CreateOffscreenLayer(nn::sf::Out<std::uint64_t> outHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateOffscreenLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rendererAruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rendererAruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rendererAruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateOffscreenLayer)

    // nn::Result DestroyOffscreenLayer(std::uint64_t handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyOffscreenLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyOffscreenLayer)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::grcsrv::IOffscreenRecorder, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::grcsrv::IOffscreenRecorder))

    // nn::Result CreateOffscreenLayer(nn::sf::Out<std::uint64_t> outHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateOffscreenLayer, (::nn::sf::Out<::std::uint64_t> outHandle, ::nn::applet::AppletResourceUserId rendererAruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateOffscreenLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rendererAruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateOffscreenLayer)
    }

    // nn::Result DestroyOffscreenLayer(std::uint64_t handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyOffscreenLayer, (::std::uint64_t handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyOffscreenLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyOffscreenLayer)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::grcsrv::IOffscreenRecorder>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::grcsrv::IOffscreenRecorder))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateOffscreenLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rendererAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyOffscreenLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateOffscreenLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyOffscreenLayer)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::grcsrv::IOffscreenRecorder))
