﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace gpio { // NOLINT(whitespace/braces)

class IPadSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPadSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPadSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDirection, (::std::int32_t direction))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDirection, (::nn::sf::Out<::std::int32_t> direction))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptMode, (::std::int32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptMode, (::nn::sf::Out<::std::int32_t> mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptEnable, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptEnable, (::nn::sf::Out<bool> enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptStatus, (::nn::sf::Out<::std::int32_t> status))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearInterruptStatus)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetValue, (::std::int32_t value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetValue, (::nn::sf::Out<::std::int32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindInterrupt, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnbindInterrupt)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceEnabled, (bool isEnable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceEnabled, (::nn::sf::Out<bool> isEnable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceTime, (int msecTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceTime, (::nn::sf::Out<int> msecTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetValueForSleepState, (::std::int32_t value))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPadSession)

        ::nn::Result SetDirection(::std::int32_t direction) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDirection, (direction));
        }

        ::nn::Result GetDirection(::nn::sf::Out<::std::int32_t> direction) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDirection, (direction));
        }

        ::nn::Result SetInterruptMode(::std::int32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInterruptMode, (mode));
        }

        ::nn::Result GetInterruptMode(::nn::sf::Out<::std::int32_t> mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterruptMode, (mode));
        }

        ::nn::Result SetInterruptEnable(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInterruptEnable, (enable));
        }

        ::nn::Result GetInterruptEnable(::nn::sf::Out<bool> enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterruptEnable, (enable));
        }

        ::nn::Result GetInterruptStatus(::nn::sf::Out<::std::int32_t> status) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterruptStatus, (status));
        }

        ::nn::Result ClearInterruptStatus() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearInterruptStatus);
        }

        ::nn::Result SetValue(::std::int32_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetValue, (value));
        }

        ::nn::Result GetValue(::nn::sf::Out<::std::int32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetValue, (outValue));
        }

        ::nn::Result BindInterrupt(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindInterrupt, (handle));
        }

        ::nn::Result UnbindInterrupt() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnbindInterrupt);
        }

        ::nn::Result SetDebounceEnabled(bool isEnable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDebounceEnabled, (isEnable));
        }

        ::nn::Result GetDebounceEnabled(::nn::sf::Out<bool> isEnable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebounceEnabled, (isEnable));
        }

        ::nn::Result SetDebounceTime(int msecTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDebounceTime, (msecTime));
        }

        ::nn::Result GetDebounceTime(::nn::sf::Out<int> msecTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebounceTime, (msecTime));
        }

        ::nn::Result SetValueForSleepState(::std::int32_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetValueForSleepState, (value));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPadSession
    {
    public:
        nn::Result SetDirection(std::int32_t direction) NN_NOEXCEPT;
        nn::Result GetDirection(nn::sf::Out<std::int32_t> direction) NN_NOEXCEPT;
        nn::Result SetInterruptMode(std::int32_t mode) NN_NOEXCEPT;
        nn::Result GetInterruptMode(nn::sf::Out<std::int32_t> mode) NN_NOEXCEPT;
        nn::Result SetInterruptEnable(bool enable) NN_NOEXCEPT;
        nn::Result GetInterruptEnable(nn::sf::Out<bool> enable) NN_NOEXCEPT;
        nn::Result GetInterruptStatus(nn::sf::Out<std::int32_t> status) NN_NOEXCEPT;
        nn::Result ClearInterruptStatus() NN_NOEXCEPT;
        nn::Result SetValue(std::int32_t value) NN_NOEXCEPT;
        nn::Result GetValue(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
        nn::Result BindInterrupt(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result UnbindInterrupt() NN_NOEXCEPT;
        nn::Result SetDebounceEnabled(bool isEnable) NN_NOEXCEPT;
        nn::Result GetDebounceEnabled(nn::sf::Out<bool> isEnable) NN_NOEXCEPT;
        nn::Result SetDebounceTime(int msecTime) NN_NOEXCEPT;
        nn::Result GetDebounceTime(nn::sf::Out<int> msecTime) NN_NOEXCEPT;
        nn::Result SetValueForSleepState(std::int32_t value) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetDirection(std::int32_t direction) NN_NOEXCEPT;
    nn::Result GetDirection(nn::sf::Out<std::int32_t> direction) NN_NOEXCEPT;
    nn::Result SetInterruptMode(std::int32_t mode) NN_NOEXCEPT;
    nn::Result GetInterruptMode(nn::sf::Out<std::int32_t> mode) NN_NOEXCEPT;
    nn::Result SetInterruptEnable(bool enable) NN_NOEXCEPT;
    nn::Result GetInterruptEnable(nn::sf::Out<bool> enable) NN_NOEXCEPT;
    nn::Result GetInterruptStatus(nn::sf::Out<std::int32_t> status) NN_NOEXCEPT;
    nn::Result ClearInterruptStatus() NN_NOEXCEPT;
    nn::Result SetValue(std::int32_t value) NN_NOEXCEPT;
    nn::Result GetValue(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
    nn::Result BindInterrupt(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result UnbindInterrupt() NN_NOEXCEPT;
    nn::Result SetDebounceEnabled(bool isEnable) NN_NOEXCEPT;
    nn::Result GetDebounceEnabled(nn::sf::Out<bool> isEnable) NN_NOEXCEPT;
    nn::Result SetDebounceTime(int msecTime) NN_NOEXCEPT;
    nn::Result GetDebounceTime(nn::sf::Out<int> msecTime) NN_NOEXCEPT;
    nn::Result SetValueForSleepState(std::int32_t value) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::gpio::IPadSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDirection, (::std::int32_t direction))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDirection, (direction));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDirection, (::nn::sf::Out<::std::int32_t> direction))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDirection, (direction));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptMode, (::std::int32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInterruptMode, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptMode, (::nn::sf::Out<::std::int32_t> mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterruptMode, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptEnable, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInterruptEnable, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptEnable, (::nn::sf::Out<bool> enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterruptEnable, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptStatus, (::nn::sf::Out<::std::int32_t> status))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterruptStatus, (status));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearInterruptStatus)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearInterruptStatus);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetValue, (::std::int32_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetValue, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValue, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetValue, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindInterrupt, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindInterrupt, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnbindInterrupt)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnbindInterrupt);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceEnabled, (bool isEnable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDebounceEnabled, (isEnable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceEnabled, (::nn::sf::Out<bool> isEnable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebounceEnabled, (isEnable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceTime, (int msecTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDebounceTime, (msecTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceTime, (::nn::sf::Out<int> msecTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebounceTime, (msecTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetValueForSleepState, (::std::int32_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetValueForSleepState, (value));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::gpio::IPadSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::gpio::IPadSession))

    // nn::Result SetDirection(std::int32_t direction) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDirection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(direction, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (direction))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(direction)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDirection)

    // nn::Result GetDirection(nn::sf::Out<std::int32_t> direction) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDirection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(direction, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (direction))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(direction)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDirection)

    // nn::Result SetInterruptMode(std::int32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInterruptMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInterruptMode)

    // nn::Result GetInterruptMode(nn::sf::Out<std::int32_t> mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterruptMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterruptMode)

    // nn::Result SetInterruptEnable(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInterruptEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInterruptEnable)

    // nn::Result GetInterruptEnable(nn::sf::Out<bool> enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterruptEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterruptEnable)

    // nn::Result GetInterruptStatus(nn::sf::Out<std::int32_t> status) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterruptStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(status, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (status))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(status)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterruptStatus)

    // nn::Result ClearInterruptStatus() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearInterruptStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearInterruptStatus)

    // nn::Result SetValue(std::int32_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetValue)

    // nn::Result GetValue(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetValue)

    // nn::Result BindInterrupt(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindInterrupt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindInterrupt)

    // nn::Result UnbindInterrupt() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnbindInterrupt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnbindInterrupt)

    // nn::Result SetDebounceEnabled(bool isEnable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDebounceEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDebounceEnabled)

    // nn::Result GetDebounceEnabled(nn::sf::Out<bool> isEnable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebounceEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isEnable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isEnable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebounceEnabled)

    // nn::Result SetDebounceTime(int msecTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDebounceTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(msecTime, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (msecTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(msecTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDebounceTime)

    // nn::Result GetDebounceTime(nn::sf::Out<int> msecTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebounceTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(msecTime, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (msecTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(msecTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebounceTime)

    // nn::Result SetValueForSleepState(std::int32_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetValueForSleepState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetValueForSleepState)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::gpio::IPadSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::gpio::IPadSession))

    // nn::Result SetDirection(std::int32_t direction) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDirection, (::std::int32_t direction))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDirection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(direction)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDirection)
    }

    // nn::Result GetDirection(nn::sf::Out<std::int32_t> direction) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDirection, (::nn::sf::Out<::std::int32_t> direction))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDirection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(direction)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDirection)
    }

    // nn::Result SetInterruptMode(std::int32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptMode, (::std::int32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInterruptMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInterruptMode)
    }

    // nn::Result GetInterruptMode(nn::sf::Out<std::int32_t> mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptMode, (::nn::sf::Out<::std::int32_t> mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterruptMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterruptMode)
    }

    // nn::Result SetInterruptEnable(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterruptEnable, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInterruptEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInterruptEnable)
    }

    // nn::Result GetInterruptEnable(nn::sf::Out<bool> enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptEnable, (::nn::sf::Out<bool> enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterruptEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterruptEnable)
    }

    // nn::Result GetInterruptStatus(nn::sf::Out<std::int32_t> status) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptStatus, (::nn::sf::Out<::std::int32_t> status))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterruptStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(status)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterruptStatus)
    }

    // nn::Result ClearInterruptStatus() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearInterruptStatus)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearInterruptStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearInterruptStatus)
    }

    // nn::Result SetValue(std::int32_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetValue, (::std::int32_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetValue)
    }

    // nn::Result GetValue(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValue, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetValue)
    }

    // nn::Result BindInterrupt(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindInterrupt, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindInterrupt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindInterrupt)
    }

    // nn::Result UnbindInterrupt() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnbindInterrupt)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnbindInterrupt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnbindInterrupt)
    }

    // nn::Result SetDebounceEnabled(bool isEnable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceEnabled, (bool isEnable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDebounceEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDebounceEnabled)
    }

    // nn::Result GetDebounceEnabled(nn::sf::Out<bool> isEnable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceEnabled, (::nn::sf::Out<bool> isEnable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebounceEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebounceEnabled)
    }

    // nn::Result SetDebounceTime(int msecTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebounceTime, (int msecTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDebounceTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(msecTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDebounceTime)
    }

    // nn::Result GetDebounceTime(nn::sf::Out<int> msecTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebounceTime, (::nn::sf::Out<int> msecTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebounceTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(msecTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebounceTime)
    }

    // nn::Result SetValueForSleepState(std::int32_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetValueForSleepState, (::std::int32_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetValueForSleepState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetValueForSleepState)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::gpio::IPadSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::gpio::IPadSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDirection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDirection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(direction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDirection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDirection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(direction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInterruptMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInterruptMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterruptMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterruptMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInterruptEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInterruptEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterruptEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterruptEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterruptStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterruptStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(status)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearInterruptStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearInterruptStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindInterrupt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindInterrupt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnbindInterrupt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnbindInterrupt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDebounceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDebounceEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebounceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebounceEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDebounceTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDebounceTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(msecTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebounceTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebounceTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(msecTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetValueForSleepState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetValueForSleepState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDirection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDirection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInterruptMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterruptMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInterruptEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterruptEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterruptStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearInterruptStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindInterrupt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnbindInterrupt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDebounceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebounceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDebounceTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebounceTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetValueForSleepState)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::gpio::IPadSession))
