﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      3DS/Wii U 世代のフレンドを扱うクラスです。
*/
class NintendoNetworkIdFriend
{
public:
    /*!
        @brief      コンストラクタです。
    */
    NintendoNetworkIdFriend() NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      Mii の名前を取得します。

        @return     Mii の名前。
    */
    const MiiName& GetMiiName() const NN_NOEXCEPT;

    /*!
        @brief      Mii 画像 URL パラメータを取得します。

        @return     Mii 画像 URL パラメータ。
    */
    const MiiImageUrlParam& GetMiiImageUrlParam() const NN_NOEXCEPT;

    /*!
        @brief      Mii 画像 URL を取得します。

        @param[out] outUrl  Mii 画像 URL。

        @return     処理結果。

        @pre
            - outUrl != nullptr
    */
    nn::Result GetMiiImageUrl(Url* outUrl) const NN_NOEXCEPT;

    /*!
        @brief      有効なデータを保持しているかどうかを確認します。

        @return     有効なデータを保持しているかどうか。
    */
    bool IsValid() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(256);
};

}}
