﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>

namespace nn { namespace friends {

namespace detail { namespace ipc {

class IDaemonSuspendSessionService;

}}

/*!
    @brief      自律動作停止の期間管理オブジェクトです。

    @details
                @ref SuspendDaemon によって生成された本オブジェクトが生存中、システムの自律動作は停止し続けます。@n
                本オブジェクトを破棄することにより、自律動作は再開します。
*/
class DaemonSuspension
{
private:
    NN_DISALLOW_COPY(DaemonSuspension);
    NN_DISALLOW_MOVE(DaemonSuspension);

public:
    /*!
        @brief      コンストラクタです。
    */
    DaemonSuspension() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DaemonSuspension() NN_NOEXCEPT;

public:
    // internal use only
    void Attach(detail::ipc::IDaemonSuspendSessionService* pService) NN_NOEXCEPT;

private:
    //
    detail::ipc::IDaemonSuspendSessionService* m_pService;
};

}}
