﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドプロフィール画像ダウンロードキューの管理モジュールです。
*/
class ImageDownloadQueueManager
{
private:
    NN_DISALLOW_COPY(ImageDownloadQueueManager);
    NN_DISALLOW_MOVE(ImageDownloadQueueManager);

public:
    /*!
        @brief      レコードです。
    */
    struct Record
    {
        // 8
        nn::account::NetworkServiceAccountId accountId;
    };

    NN_STATIC_ASSERT(sizeof (Record) == 8);

private:
    /*!
        @brief      コンストラクタです。
    */
    ImageDownloadQueueManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ImageDownloadQueueManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ImageDownloadQueueManager, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      ダウンロード対象を追加します。

        @param[in]  uid         ユーザーアカウント。
        @param[in]  accountId   フレンドのネットワークサービスアカウント ID。

        @return     処理結果。
    */
    nn::Result Add(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

    /*!
        @brief      ダウンロード対象を削除します。

        @param[in]  uid         ユーザーアカウント。
        @param[in]  accountId   フレンドのネットワークサービスアカウント ID。

        @return     処理結果。
    */
    nn::Result Remove(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

    /*!
        @brief      ダウンロード対象を 1 つ取得します。

        @param[out] outAccountId    フレンドのネットワークサービスアカウント ID。
        @param[in]  uid             ユーザーアカウント。

        @return     処理結果。

        @pre
            - outAccountId != nullptr
    */
    nn::Result Pop(nn::account::NetworkServiceAccountId* outAccountId, const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      ダウンロードキューを保存します。

        @return     処理結果。
    */
    nn::Result Save() NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::account::Uid m_CurrentUid;
    //
    Record m_Records[FriendCountMax];
    int m_Count;
    //
    bool m_IsDirty;

private:
    //
    nn::Result Load(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadImpl(const nn::account::Uid& uid) NN_NOEXCEPT;
};

}}}}}
