﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ブロックサイズです。
*/
const int64_t BlockSize = 16 * 1024;

/*!
    @brief      システム情報ストレージのサイズです。

    @details
                内訳は以下の通りです。

                -- 1 block: 16KB
                - フレンドプロフィール画像管理情報
                -- friends-sys:/image_record.bin
                -- 38KB
                -- 3 blocks: 48KB
                - エントリー情報
                -- 2 blocks: 32KB

                合計：5 blocks: 80KB

                設定値：16 blocks: 256KB (reserved 11 blocks: 176KB)
*/
const int64_t SystemStorageSize = 16 * BlockSize;

/*!
    @brief      システム情報ストレージのジャーナルサイズです。

    @details
                一番ジャーナルを消費するアクセスは以下の通りです。

                - フレンドプロフィール画像管理情報の作成
                -- 作成：1
                -- 書込：3

                合計：4 blocks: 64KB

                設定値：8 blocks: 128KB (reserved 4 blocks: 64KB)
*/
static const int64_t SystemStorageJournalSize = 8 * BlockSize;

/*!
    @brief      プロフィール画像キャッシュストレージのサイズです。

    @details
                内訳は以下の通りです。

                - プロフィール画像
                -- friends-image:/image/<nsaid>_<urlhash>.jpg
                -- MAX 128KB
                -- 8 blocks: 128KB
                -- ストレージに空きがない場合、古いものから削除する。
                - エントリー情報
                -- 2 blocks: 32KB

                設定値：5120 blocks: 81920KB
*/
const int64_t ImageStorageSize = 5120 * BlockSize;

/*!
    @brief      プロフィール画像キャッシュストレージのジャーナルサイズです。

    @details
                一番ジャーナルを消費するアクセスは以下の通りです。

                - 画像の書き込み
                -- 削除：8 (128KB 空けるためには、最大 8 個削除する)
                -- 作成：2 (ディレクトリ、ファイル)
                -- 書込：8

                合計：18 blocks: 288KB

                設定値：32 blocks: 512KB (reserved 14 blocks: 224KB)
*/
static const int64_t ImageStorageJournalSize = 32 * BlockSize;

}}}}}
