﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      バックグラウンドタスクの実行スレッドです。
*/
class BackgroundTaskThread
{
public:
    /*!
        @brief      スレッドの実行を開始します。
    */
    static void Start() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を終了します。
    */
    static void Stop() NN_NOEXCEPT;

    /*!
        @brief      バックグラウンドタスクの処理を停止します。

        @details
                    本関数は、バックグラウンドタスクのキャンセル要求を出した後、処理が停止するまで待機します。
    */
    static void Suspend() NN_NOEXCEPT;

    /*!
        @brief      バックグラウンドタスクの処理を開始します。
    */
    static void Resume() NN_NOEXCEPT;

    /*!
        @brief      スリープを通知します。
    */
    static void NotifySleep() NN_NOEXCEPT;

    /*!
        @brief      スリープ復帰を通知します。
    */
    static void NotifySleepAwaked() NN_NOEXCEPT;

    /*!
        @brief      半起床を通知します。
    */
    static void NotifyMinimumAwaked() NN_NOEXCEPT;
};

}}}}}
