﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>
#include <nn/friends/friends_TypesAdmin.h>

namespace nn { namespace friends { namespace detail {

/*!
    @brief      オンラインプレイの宣言状態です。
*/
enum OnlinePlayDeclaration : int8_t
{
    OnlinePlayDeclaration_None  = 0, //!< 未宣言。
    OnlinePlayDeclaration_Open  = 1, //!< 開始宣言。
    OnlinePlayDeclaration_Close = 2  //!< 終了宣言。
};

/*!
    @brief      経路情報の拡張データです。
*/
union RouteInfoExtra
{
    struct
    {
        ExternalApplicationCatalogId catalogId;
    }
    candidate;
    struct
    {
        MiiName miiName;
        MiiImageUrlParam miiImageUrlParam;
    }
    nnid;
};

}}}
