﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Presence.h>
#include <nn/friends/detail/friends_MacrosImpl.h>

namespace nn { namespace friends { namespace detail {

NN_DETAIL_FRIENDS_BEGIN_IMPL(UserPresence)
{
    // 16
    nn::account::Uid uid;
    // 8
    NN_PADDING8;
    // 1
    int8_t onlinePlayDeclaration;
    // 7
    NN_PADDING7;
    // 192
    char appField[PresenceAppFieldSize];
}
NN_DETAIL_FRIENDS_END_IMPL(UserPresence);

NN_DETAIL_FRIENDS_BEGIN_IMPL(FriendPresence)
{
    // 16
    ApplicationInfo lastPlayedApp;
    // 8
    nn::time::PosixTime lastUpdateTime;
    // 4
    int32_t status;
    // 1
    bool isSamePresenceGroupApp;
    // 3
    NN_PADDING3;
    // 192
    char appField[PresenceAppFieldSize];
}
NN_DETAIL_FRIENDS_END_IMPL(FriendPresence);

inline bool operator==(const FriendPresenceImpl& lhs, const FriendPresenceImpl& rhs) NN_NOEXCEPT
{
    return
        lhs.data.lastPlayedApp.appId == rhs.data.lastPlayedApp.appId &&
        lhs.data.lastPlayedApp.presenceGroupId == rhs.data.lastPlayedApp.presenceGroupId &&
        lhs.data.lastUpdateTime == rhs.data.lastUpdateTime &&
        lhs.data.status == rhs.data.status &&
        std::memcmp(lhs.data.appField, rhs.data.appField, PresenceAppFieldSize) == 0;
}

inline bool operator!=(const FriendPresenceImpl& lhs, const FriendPresenceImpl& rhs) NN_NOEXCEPT
{
    return !(lhs == rhs);
}

}}}
