﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>
#include <nn/friends/friends_TypesAdmin.h>

namespace nn { namespace friends { namespace detail {

/*!
    @brief      カレントユーザーアカウントを取得します。

    @return     カレントユーザーアカウント。

    @details
                カレントユーザーアカウントとは、Open 状態のユーザーアカウント数が 1 の場合に自動的に選択されるユーザーアカウントを指します。@n
                Open 状態のユーザーアカウント数が 1 でない場合、本関数は ASSERT します。
*/
nn::account::Uid GetCurrentUser() NN_NOEXCEPT;

/*!
    @brief      ユーザーアカウントの状態を確認します。

    @param[in]  uid ユーザーアカウント。

    @return     処理結果。

    @details
                ユーザーアカウントが Open 状態でない場合、 ResultUserNotOpened を返します。
*/
nn::Result CheckUserStatus(const nn::account::Uid& uid) NN_NOEXCEPT;

/*!
    @brief      ユーザーアカウントの Open 状態確認の有効／無効を設定します。

    @param[in]  isEnabled   Open 状態確認フラグ。

    @details
                無効化することで、ユーザーアカウントの状態に関わらず @ref CheckUserStatus は成功を返します。
*/
void EnableCheckUserStatus(bool isEnabled = true) NN_NOEXCEPT;

/*!
    @brief      インターネット利用要求が受理されているかどうかを確認します。

    @return     処理結果。
*/
nn::Result CheckInternetRequestAccepted() NN_NOEXCEPT;

/*!
    @brief      アプリ内表示名を正規化します。

    @param[out] out 正規化後のアプリ内表示名。
    @param[in]  in  正規化前のアプリ内表示名。

    @return     処理結果。

    @pre
        - out != nullptr

    @details
                正規化を行うことで、strcpy 等でアプリ内表示名がバッファに書き込まれたとしても、妥当な UTF-8 文字列が格納されるようになります。
*/
nn::Result NormalizeInAppScreenName(InAppScreenName* out, const InAppScreenName& in) NN_NOEXCEPT;

/*!
    @brief      Mii 画像 URL を取得します。

    @param[out] outUrl              Mii 画像 URL。
    @param[in]  miiImageUrlParam    Mii 画像 URL パラメータ。

    @return     処理結果。

    @pre
        - outUrl != nullptr
*/
nn::Result GetMiiImageUrl(Url* outUrl, const MiiImageUrlParam& miiImageUrlParam) NN_NOEXCEPT;

}}}
