﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>
#include <nn/es/detail/es_Log.h>

// 開発時にログ出力を有効にしたいものだけ、コメントを外す。
// INFO と ERR だけは常にログ出力を有効にしておく。

//#define NN_ES_SERVICE_LOG(...)       NN_DETAIL_ES_INFO("" __VA_ARGS__)
#define NN_ES_SERVICE_LOG_INFO(...)  NN_DETAIL_ES_INFO("INFO: " __VA_ARGS__)
//#define NN_ES_SERVICE_LOG_WARN(...)  NN_DETAIL_ES_WARN("WARN: " __VA_ARGS__)
#define NN_ES_SERVICE_LOG_ERR(...)   NN_DETAIL_ES_ERROR("ERR: " __VA_ARGS__)
//#define NN_ES_SERVICE_LOG_TRACE(...) NN_DETAIL_ES_TRACE("TRACE: " __VA_ARGS__)
//#define NN_ES_SERVICE_LOG_FATAL(...) NN_DETAIL_ES_FATAL("FATAL: " __VA_ARGS__)

// 未定義時用の空定義（ここから下は変更不要）
#ifndef NN_ES_SERVICE_LOG
#define NN_ES_SERVICE_LOG(...)
#endif
#ifndef NN_ES_SERVICE_LOG_INFO
#define NN_ES_SERVICE_LOG_INFO(...)
#endif
#ifndef NN_ES_SERVICE_LOG_WARN
#define NN_ES_SERVICE_LOG_WARN(...)
#endif
#ifndef NN_ES_SERVICE_LOG_ERR
#define NN_ES_SERVICE_LOG_ERR(...)
#endif
#ifndef NN_ES_SERVICE_LOG_TRACE
#define NN_ES_SERVICE_LOG_TRACE(...)
#endif
#ifndef NN_ES_SERVICE_LOG_FATAL
#define NN_ES_SERVICE_LOG_FATAL(...)
#endif
