﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief Error report service types (private).
*/

namespace nn   {
namespace erpt {

/**
 * @brief msgpack types' tag supported by error report.
 *        Note that not all msgpack types are supported.
 */
enum ValueTypeTag
{
    Bin             = 0xc4,
    Bin16384        = 0xc5,
    Str             = 0xa0,
    Str256          = 0xd9,
    Str16384        = 0xda,
    U8              = 0xcc,
    U16             = 0xcd,
    U32             = 0xce,
    U64             = 0xcf,
    I8              = 0xd0,
    I16             = 0xd1,
    I32             = 0xd2,
    I64             = 0xd3,
    Array16         = 0x90,
    Array16384      = 0xdc,
    Map16           = 0x80,
    Map16384        = 0xde,
    False           = 0xc2,
    True            = 0xc3,
};

}}
