﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Event.h>

namespace nn { namespace codec { namespace server {

class HardwareOpusDecoder
{
public:

    class Service
    {
    public:
        static void Initialize() NN_NOEXCEPT;
        static void DoListening() NN_NOEXCEPT;
        static void Exit() NN_NOEXCEPT;
        static void Finalize() NN_NOEXCEPT;
        static void Wait() NN_NOEXCEPT;
        static void Sleep() NN_NOEXCEPT;
        static void Wake() NN_NOEXCEPT;
        static inline bool IsFinalizing() NN_NOEXCEPT
        {
            return g_IsFinalizing;
        }
    private:
        static void RequestStopListening() NN_NOEXCEPT;

        static nn::os::EventType g_ActionWaiter;
        static bool g_IsInitialized;
        static bool g_IsListening;
        static bool g_IsFinalizing;
        static bool g_IsReadyForSleep;
    };

    class Hardware
    {
    public:
        static void Initialize() NN_NOEXCEPT;
        static void Finalize() NN_NOEXCEPT;
    private:
        static bool g_IsInitialized;
    };
};

}}} // namespace nn::codec::server
