﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief       HardwareOpus の、NX に関するデータ型を定義します。
 */

namespace nn {
namespace codec {
namespace detail {

/**
 * @brief       Opus マネージャとの間のメールボックス番号を表す列挙型です。
 */
enum AdspMailboxId
{
    AdspMailboxId_HardwareOpus_BidirectionalPath = 70
};

/**
 * @brief       HardwareOpusDecoder の IPC 機能に関する各種定数を表す列挙型です。
 */
enum HardwareOpusDecoderIpcConstants
{
    HardwareOpusDecoderIpcConstants_SessionCountMax = 24,
    HardwareOpusDecoderIpcConstants_SessionHeapSize = 8 * 1024,
};

}  // namespace detail
}  // namespace codec
}  // namespace nn

