﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/bluetooth/bluetooth_LeTypes.h>
#include <nn/btm/btm_Types.h>
#include <nn/btm/user/btm_UserTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace btm { // NOLINT(whitespace/braces)

class IBtm;

class IBtmDebug;

class IBtmSystem;

class IBtmSystemCore;

class IBtmUser;

class IBtmUserCore;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtm, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtm)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetStateImpl, (::nn::sf::Out<::nn::btm::BtmState> pState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetHostDevicePropertyImpl, (::nn::sf::Out<::nn::btm::HostDeviceProperty> pHostDeviceProperty))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceConditionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceConditionImpl, (::nn::sf::Out<::nn::btm::DeviceConditionList> pList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBurstModeImpl, (::nn::btm::BdAddress bdAddress, bool isBurstMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSlotModeImpl, (const ::nn::btm::DeviceSlotModeList& deviceSlotModeList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBluetoothModeImpl, (::nn::btm::BluetoothMode bluetoothMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWlanModeImpl, (::nn::btm::WlanMode wlanMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceInfoEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceInfoImpl, (::nn::sf::Out<::nn::btm::DeviceInfoList> pList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(AddDeviceInfoImpl, (const ::nn::btm::DeviceInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(RemoveDeviceInfoImpl, (::nn::btm::BdAddress address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(IncreaseDeviceInfoOrderImpl, (::nn::btm::BdAddress address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LlrNotifyImpl, (::nn::btm::BdAddress address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(HidDisconnectImpl, (::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidSetRetransmissionModeImpl, (::nn::btm::BdAddress bdAddress, const ::nn::btm::ZeroRetransmissionList& zeroRetransmissionList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireAwakeReqEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireLlrStateEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsLlrStartedImpl, (bool))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EnableSlotSavingImpl, (bool isEnable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(ProtectDeviceInfoImpl, (::nn::btm::BdAddress address, bool isProtect))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleOverrideConnectionImpl, (::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(BleGetGattClientConditionListImpl, (::nn::sf::Out<::nn::btm::GattClientConditionList> pGattClientConditionList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::std::uint32_t connectionHandle, ::std::uint16_t mtu))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t appletId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtm)

        void GetStateImpl(::nn::sf::Out<::nn::btm::BtmState> pState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetStateImpl, (pState));
        }

        void GetHostDevicePropertyImpl(::nn::sf::Out<::nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetHostDevicePropertyImpl, (pHostDeviceProperty));
        }

        bool AcquireDeviceConditionEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireDeviceConditionEventImpl, (bool), (handle));
        }

        void GetDeviceConditionImpl(::nn::sf::Out<::nn::btm::DeviceConditionList> pList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetDeviceConditionImpl, (pList));
        }

        ::nn::Result SetBurstModeImpl(::nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBurstModeImpl, (bdAddress, isBurstMode));
        }

        ::nn::Result SetSlotModeImpl(const ::nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSlotModeImpl, (deviceSlotModeList));
        }

        ::nn::Result SetBluetoothModeImpl(::nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBluetoothModeImpl, (bluetoothMode));
        }

        ::nn::Result SetWlanModeImpl(::nn::btm::WlanMode wlanMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWlanModeImpl, (wlanMode));
        }

        bool AcquireDeviceInfoEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireDeviceInfoEventImpl, (bool), (handle));
        }

        void GetDeviceInfoImpl(::nn::sf::Out<::nn::btm::DeviceInfoList> pList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetDeviceInfoImpl, (pList));
        }

        void AddDeviceInfoImpl(const ::nn::btm::DeviceInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(AddDeviceInfoImpl, (info));
        }

        void RemoveDeviceInfoImpl(::nn::btm::BdAddress address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(RemoveDeviceInfoImpl, (address));
        }

        void IncreaseDeviceInfoOrderImpl(::nn::btm::BdAddress address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(IncreaseDeviceInfoOrderImpl, (address));
        }

        ::nn::Result LlrNotifyImpl(::nn::btm::BdAddress address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LlrNotifyImpl, (address));
        }

        void EnableRadioImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableRadioImpl);
        }

        void DisableRadioImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableRadioImpl);
        }

        void HidDisconnectImpl(::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(HidDisconnectImpl, (bdAddress));
        }

        ::nn::Result HidSetRetransmissionModeImpl(::nn::btm::BdAddress bdAddress, const ::nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidSetRetransmissionModeImpl, (bdAddress, zeroRetransmissionList));
        }

        bool AcquireAwakeReqEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireAwakeReqEventImpl, (bool), (handle));
        }

        bool AcquireLlrStateEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireLlrStateEventImpl, (bool), (handle));
        }

        bool IsLlrStartedImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsLlrStartedImpl, (bool));
        }

        void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EnableSlotSavingImpl, (isEnable));
        }

        void ProtectDeviceInfoImpl(::nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(ProtectDeviceInfoImpl, (address, isProtect));
        }

        bool AcquireBleScanEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (handle));
        }

        ::nn::Result GetBleScanParameterGeneralImpl(::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (pFilter, parameterId));
        }

        ::nn::Result GetBleScanParameterSmartDeviceImpl(::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (pFilter, parameterId));
        }

        ::nn::Result StartBleScanForGeneralImpl(::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (filter));
        }

        ::nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl);
        }

        void GetBleScanResultsForGeneralImpl(const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (pResult, pOutNum));
        }

        ::nn::Result StartBleScanForPairedDeviceImpl(::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (filter));
        }

        ::nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl);
        }

        ::nn::Result StartBleScanForSmartDeviceImpl(const ::nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (filter));
        }

        ::nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl);
        }

        void GetBleScanResultsForSmartDeviceImpl(const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (pResult, pOutNum));
        }

        bool AcquireBleConnectionEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (handle));
        }

        ::nn::Result BleConnectImpl(::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleConnectImpl, (bdAddress));
        }

        ::nn::Result BleOverrideConnectionImpl(::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleOverrideConnectionImpl, (connectionHandle));
        }

        ::nn::Result BleDisconnectImpl(::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (connectionHandle));
        }

        void BleGetConnectionStateImpl(const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (pConnState, pOutNum));
        }

        void BleGetGattClientConditionListImpl(::nn::sf::Out<::nn::btm::GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(BleGetGattClientConditionListImpl, (pGattClientConditionList));
        }

        bool AcquireBlePairingEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (handle));
        }

        ::nn::Result BlePairDeviceImpl(::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (connectionHandle, filter));
        }

        ::nn::Result BleUnpairDeviceOnBothImpl(::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (connectionHandle, filter));
        }

        ::nn::Result BleUnpairDeviceImpl(::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (bdAddress, filter));
        }

        void BleGetPairedAddressesImpl(const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (pAddresses, pOutNum, filter));
        }

        bool AcquireBleServiceDiscoveryEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (handle));
        }

        void GetGattServicesImpl(const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattServicesImpl, (pServices, pOutNum, connectionHandle));
        }

        bool GetGattServiceImpl(::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (pService, connectionHandle, uuid));
        }

        void GetGattIncludedServicesImpl(const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (pIncludedServices, pOutNum, connectionHandle, serviceHandle));
        }

        bool GetBelongingServiceImpl(::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (pService, connectionHandle, attributeHandle));
        }

        void GetGattCharacteristicsImpl(const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (pCharacteristics, pOutNum, connectionHandle, serviceHandle));
        }

        void GetGattDescriptorsImpl(const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (pDescriptors, pOutNum, connectionHandle, charHandle));
        }

        bool AcquireBleMtuConfigEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (handle));
        }

        ::nn::Result ConfigureBleMtuImpl(::std::uint32_t connectionHandle, ::std::uint16_t mtu) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (connectionHandle, mtu));
        }

        void GetBleMtuImpl(::nn::sf::Out<::std::uint16_t> mtu, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleMtuImpl, (mtu, connectionHandle));
        }

        ::nn::Result RegisterBleGattDataPathImpl(const ::nn::btm::user::BleDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (path));
        }

        ::nn::Result UnregisterBleGattDataPathImpl(const ::nn::btm::user::BleDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (path));
        }

        ::nn::Result RegisterAppletResourceUserIdImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t appletId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserIdImpl, (aruid, appletId));
        }

        ::nn::Result UnregisterAppletResourceUserIdImpl(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserIdImpl, (aruid));
        }

        ::nn::Result SetAppletResourceUserIdImpl(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAppletResourceUserIdImpl, (aruid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtm
    {
    public:
        void GetStateImpl(nn::sf::Out<nn::btm::BtmState> pState) NN_NOEXCEPT;
        void GetHostDevicePropertyImpl(nn::sf::Out<nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT;
        bool AcquireDeviceConditionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        void GetDeviceConditionImpl(nn::sf::Out<nn::btm::DeviceConditionList> pList) NN_NOEXCEPT;
        nn::Result SetBurstModeImpl(nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT;
        nn::Result SetSlotModeImpl(const nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT;
        nn::Result SetBluetoothModeImpl(nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT;
        nn::Result SetWlanModeImpl(nn::btm::WlanMode wlanMode) NN_NOEXCEPT;
        bool AcquireDeviceInfoEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        void GetDeviceInfoImpl(nn::sf::Out<nn::btm::DeviceInfoList> pList) NN_NOEXCEPT;
        void AddDeviceInfoImpl(const nn::btm::DeviceInfo& info) NN_NOEXCEPT;
        void RemoveDeviceInfoImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
        void IncreaseDeviceInfoOrderImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
        nn::Result LlrNotifyImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
        void EnableRadioImpl() NN_NOEXCEPT;
        void DisableRadioImpl() NN_NOEXCEPT;
        void HidDisconnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        nn::Result HidSetRetransmissionModeImpl(nn::btm::BdAddress bdAddress, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT;
        bool AcquireAwakeReqEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        bool AcquireLlrStateEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        bool IsLlrStartedImpl() NN_NOEXCEPT;
        void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT;
        void ProtectDeviceInfoImpl(nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT;
        bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
        nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
        nn::Result StartBleScanForGeneralImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
        void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
        nn::Result StartBleScanForPairedDeviceImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;
        nn::Result StartBleScanForSmartDeviceImpl(const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT;
        nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
        void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
        bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result BleConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        nn::Result BleOverrideConnectionImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
        nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
        void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
        void BleGetGattClientConditionListImpl(nn::sf::Out<nn::btm::GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT;
        bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle) NN_NOEXCEPT;
        bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
        bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT;
        void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
        void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT;
        bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result ConfigureBleMtuImpl(std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT;
        void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, std::uint32_t connectionHandle) NN_NOEXCEPT;
        nn::Result RegisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
        nn::Result UnregisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
        nn::Result RegisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t appletId) NN_NOEXCEPT;
        nn::Result UnregisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    void GetStateImpl(nn::sf::Out<nn::btm::BtmState> pState) NN_NOEXCEPT;
    void GetHostDevicePropertyImpl(nn::sf::Out<nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT;
    bool AcquireDeviceConditionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetDeviceConditionImpl(nn::sf::Out<nn::btm::DeviceConditionList> pList) NN_NOEXCEPT;
    nn::Result SetBurstModeImpl(nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT;
    nn::Result SetSlotModeImpl(const nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT;
    nn::Result SetBluetoothModeImpl(nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT;
    nn::Result SetWlanModeImpl(nn::btm::WlanMode wlanMode) NN_NOEXCEPT;
    bool AcquireDeviceInfoEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetDeviceInfoImpl(nn::sf::Out<nn::btm::DeviceInfoList> pList) NN_NOEXCEPT;
    void AddDeviceInfoImpl(const nn::btm::DeviceInfo& info) NN_NOEXCEPT;
    void RemoveDeviceInfoImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    void IncreaseDeviceInfoOrderImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    nn::Result LlrNotifyImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    void EnableRadioImpl() NN_NOEXCEPT;
    void DisableRadioImpl() NN_NOEXCEPT;
    void HidDisconnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result HidSetRetransmissionModeImpl(nn::btm::BdAddress bdAddress, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT;
    bool AcquireAwakeReqEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    bool AcquireLlrStateEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    bool IsLlrStartedImpl() NN_NOEXCEPT;
    void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT;
    void ProtectDeviceInfoImpl(nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT;
    bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
    nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
    nn::Result StartBleScanForGeneralImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
    void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
    nn::Result StartBleScanForPairedDeviceImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;
    nn::Result StartBleScanForSmartDeviceImpl(const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT;
    nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
    void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
    bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BleConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result BleOverrideConnectionImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
    nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
    void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT;
    void BleGetGattClientConditionListImpl(nn::sf::Out<nn::btm::GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT;
    bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
    bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT;
    void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT;
    bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result ConfigureBleMtuImpl(std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT;
    void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, std::uint32_t connectionHandle) NN_NOEXCEPT;
    nn::Result RegisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
    nn::Result UnregisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
    nn::Result RegisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t appletId) NN_NOEXCEPT;
    nn::Result UnregisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result SetAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtm))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetStateImpl, (::nn::sf::Out<::nn::btm::BtmState> pState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetStateImpl, (pState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetHostDevicePropertyImpl, (::nn::sf::Out<::nn::btm::HostDeviceProperty> pHostDeviceProperty))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetHostDevicePropertyImpl, (pHostDeviceProperty));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceConditionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireDeviceConditionEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceConditionImpl, (::nn::sf::Out<::nn::btm::DeviceConditionList> pList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetDeviceConditionImpl, (pList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBurstModeImpl, (::nn::btm::BdAddress bdAddress, bool isBurstMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBurstModeImpl, (bdAddress, isBurstMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSlotModeImpl, (const ::nn::btm::DeviceSlotModeList& deviceSlotModeList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSlotModeImpl, (deviceSlotModeList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBluetoothModeImpl, (::nn::btm::BluetoothMode bluetoothMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBluetoothModeImpl, (bluetoothMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWlanModeImpl, (::nn::btm::WlanMode wlanMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWlanModeImpl, (wlanMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceInfoEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireDeviceInfoEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceInfoImpl, (::nn::sf::Out<::nn::btm::DeviceInfoList> pList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetDeviceInfoImpl, (pList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(AddDeviceInfoImpl, (const ::nn::btm::DeviceInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(AddDeviceInfoImpl, (info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(RemoveDeviceInfoImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(RemoveDeviceInfoImpl, (address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(IncreaseDeviceInfoOrderImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(IncreaseDeviceInfoOrderImpl, (address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LlrNotifyImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LlrNotifyImpl, (address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableRadioImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableRadioImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(HidDisconnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(HidDisconnectImpl, (bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSetRetransmissionModeImpl, (::nn::btm::BdAddress bdAddress, const ::nn::btm::ZeroRetransmissionList& zeroRetransmissionList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidSetRetransmissionModeImpl, (bdAddress, zeroRetransmissionList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireAwakeReqEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireAwakeReqEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireLlrStateEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireLlrStateEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsLlrStartedImpl, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsLlrStartedImpl, (bool));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableSlotSavingImpl, (bool isEnable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EnableSlotSavingImpl, (isEnable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(ProtectDeviceInfoImpl, (::nn::btm::BdAddress address, bool isProtect))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(ProtectDeviceInfoImpl, (address, isProtect));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (pFilter, parameterId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (pFilter, parameterId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForGeneralImpl, (filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForGeneralImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (pResult, pOutNum));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (pResult, pOutNum));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleConnectImpl, (bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleOverrideConnectionImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleOverrideConnectionImpl, (connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleDisconnectImpl, (connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(BleGetConnectionStateImpl, (pConnState, pOutNum));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetGattClientConditionListImpl, (::nn::sf::Out<::nn::btm::GattClientConditionList> pGattClientConditionList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(BleGetGattClientConditionListImpl, (pGattClientConditionList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BlePairDeviceImpl, (connectionHandle, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (connectionHandle, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleUnpairDeviceImpl, (bdAddress, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(BleGetPairedAddressesImpl, (pAddresses, pOutNum, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattServicesImpl, (pServices, pOutNum, connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetGattServiceImpl, (bool), (pService, connectionHandle, uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattIncludedServicesImpl, (pIncludedServices, pOutNum, connectionHandle, serviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (pService, connectionHandle, attributeHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattCharacteristicsImpl, (pCharacteristics, pOutNum, connectionHandle, serviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattDescriptorsImpl, (pDescriptors, pOutNum, connectionHandle, charHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::std::uint32_t connectionHandle, ::std::uint16_t mtu))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfigureBleMtuImpl, (connectionHandle, mtu));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleMtuImpl, (mtu, connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t appletId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterAppletResourceUserIdImpl, (aruid, appletId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterAppletResourceUserIdImpl, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAppletResourceUserIdImpl, (aruid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtm>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtm))

    // void GetStateImpl(nn::sf::Out<nn::btm::BtmState> pState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pState, (::nn::btm::BtmState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateImpl)

    // void GetHostDevicePropertyImpl(nn::sf::Out<nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostDevicePropertyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pHostDeviceProperty, (::nn::btm::HostDeviceProperty), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pHostDeviceProperty))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(42)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pHostDeviceProperty)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostDevicePropertyImpl)

    // bool AcquireDeviceConditionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireDeviceConditionEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireDeviceConditionEventImpl)

    // void GetDeviceConditionImpl(nn::sf::Out<nn::btm::DeviceConditionList> pList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceConditionImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pList, 0, (::nn::sf::Out<::nn::btm::DeviceConditionList>), 880, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceConditionImpl)

    // nn::Result SetBurstModeImpl(nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBurstModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isBurstMode, (bool), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bdAddress, isBurstMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isBurstMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBurstModeImpl)

    // nn::Result SetSlotModeImpl(const nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSlotModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(deviceSlotModeList, 0, (const ::nn::btm::DeviceSlotModeList&), 100, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (deviceSlotModeList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceSlotModeList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSlotModeImpl)

    // nn::Result SetBluetoothModeImpl(nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBluetoothModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothMode, (::nn::btm::BluetoothMode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBluetoothModeImpl)

    // nn::Result SetWlanModeImpl(nn::btm::WlanMode wlanMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWlanModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(wlanMode, (::nn::btm::WlanMode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (wlanMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(wlanMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWlanModeImpl)

    // bool AcquireDeviceInfoEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireDeviceInfoEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireDeviceInfoEventImpl)

    // void GetDeviceInfoImpl(nn::sf::Out<nn::btm::DeviceInfoList> pList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pList, 0, (::nn::sf::Out<::nn::btm::DeviceInfoList>), 964, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceInfoImpl)

    // void AddDeviceInfoImpl(const nn::btm::DeviceInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddDeviceInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::btm::DeviceInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(96)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddDeviceInfoImpl)

    // void RemoveDeviceInfoImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveDeviceInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveDeviceInfoImpl)

    // void IncreaseDeviceInfoOrderImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IncreaseDeviceInfoOrderImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IncreaseDeviceInfoOrderImpl)

    // nn::Result LlrNotifyImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LlrNotifyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LlrNotifyImpl)

    // void EnableRadioImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableRadioImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableRadioImpl)

    // void DisableRadioImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableRadioImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableRadioImpl)

    // void HidDisconnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidDisconnectImpl)

    // nn::Result HidSetRetransmissionModeImpl(nn::btm::BdAddress bdAddress, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidSetRetransmissionModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(zeroRetransmissionList, 0, (const ::nn::btm::ZeroRetransmissionList&), 17, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (zeroRetransmissionList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(zeroRetransmissionList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidSetRetransmissionModeImpl)

    // bool AcquireAwakeReqEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireAwakeReqEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireAwakeReqEventImpl)

    // bool AcquireLlrStateEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireLlrStateEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireLlrStateEventImpl)

    // bool IsLlrStartedImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsLlrStartedImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsLlrStartedImpl)

    // void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableSlotSavingImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableSlotSavingImpl)

    // void ProtectDeviceInfoImpl(nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ProtectDeviceInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isProtect, (bool), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (address, isProtect))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isProtect)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ProtectDeviceInfoImpl)

    // bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleScanEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleScanEventImpl)

    // nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanParameterGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameterId, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (parameterId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pFilter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFilter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameterId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanParameterGeneralImpl)

    // nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanParameterSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameterId, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (parameterId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pFilter, (::nn::btm::user::BleAdvFilterForSmartDevice), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFilter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameterId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanParameterSmartDeviceImpl)

    // nn::Result StartBleScanForGeneralImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForGeneralImpl)

    // nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForGeneralImpl)

    // void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanResultsForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pResult, 0, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pResult))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanResultsForGeneralImpl)

    // nn::Result StartBleScanForPairedDeviceImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForPairedDeviceImpl)

    // nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForPairedDeviceImpl)

    // nn::Result StartBleScanForSmartDeviceImpl(const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForSmartDevice), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForSmartDeviceImpl)

    // nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForSmartDeviceImpl)

    // void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanResultsForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pResult, 0, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pResult))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanResultsForSmartDeviceImpl)

    // bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleConnectionEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleConnectionEventImpl)

    // nn::Result BleConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleConnectImpl)

    // nn::Result BleOverrideConnectionImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleOverrideConnectionImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleOverrideConnectionImpl)

    // nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleDisconnectImpl)

    // void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleGetConnectionStateImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pConnState, 0, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pConnState))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pConnState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleGetConnectionStateImpl)

    // void BleGetGattClientConditionListImpl(nn::sf::Out<nn::btm::GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleGetGattClientConditionListImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pGattClientConditionList, 0, (::nn::sf::Out<::nn::btm::GattClientConditionList>), 116, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pGattClientConditionList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pGattClientConditionList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleGetGattClientConditionListImpl)

    // bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBlePairingEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBlePairingEventImpl)

    // nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BlePairDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BlePairDeviceImpl)

    // nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleUnpairDeviceOnBothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleUnpairDeviceOnBothImpl)

    // nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleUnpairDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bdAddress, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(14)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleUnpairDeviceImpl)

    // void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleGetPairedAddressesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pAddresses, 0, (const ::nn::sf::OutArray<::nn::btm::BdAddress>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pAddresses))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAddresses), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleGetPairedAddressesImpl)

    // bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleServiceDiscoveryEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleServiceDiscoveryEventImpl)

    // void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattServicesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pServices, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattService>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pServices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pServices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattServicesImpl)

    // bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pService, 0, (::nn::sf::Out<::nn::btm::user::GattService>), 36, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connectionHandle, uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattServiceImpl)

    // void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattIncludedServicesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pIncludedServices, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattService>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pIncludedServices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (serviceHandle, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pIncludedServices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattIncludedServicesImpl)

    // bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBelongingServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pService, 0, (::nn::sf::Out<::nn::btm::user::GattService>), 36, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attributeHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (attributeHandle, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attributeHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBelongingServiceImpl)

    // void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattCharacteristicsImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pCharacteristics, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pCharacteristics))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (serviceHandle, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCharacteristics), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattCharacteristicsImpl)

    // void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattDescriptorsImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pDescriptors, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pDescriptors))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (charHandle, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattDescriptorsImpl)

    // bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleMtuConfigEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleMtuConfigEventImpl)

    // nn::Result ConfigureBleMtuImpl(std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfigureBleMtuImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(53)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mtu, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mtu, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mtu)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfigureBleMtuImpl)

    // void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleMtuImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(54)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mtu, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mtu))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mtu), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleMtuImpl)

    // nn::Result RegisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBleGattDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(55)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(path, (::nn::btm::user::BleDataPath), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (path))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBleGattDataPathImpl)

    // nn::Result UnregisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterBleGattDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(path, (::nn::btm::user::BleDataPath), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (path))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterBleGattDataPathImpl)

    // nn::Result RegisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t appletId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterAppletResourceUserIdImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(57)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appletId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterAppletResourceUserIdImpl)

    // nn::Result UnregisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAppletResourceUserIdImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAppletResourceUserIdImpl)

    // nn::Result SetAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAppletResourceUserIdImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(59)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAppletResourceUserIdImpl)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::BtmState), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::HostDeviceProperty), 42, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::DeviceConditionList), 880, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::BdAddress), 6, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::DeviceSlotModeList), 100, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::BluetoothMode), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::WlanMode), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::DeviceInfoList), 964, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::DeviceInfo), 96, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::ZeroRetransmissionList), 17, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleAdvFilterForGeneral), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleAdvFilterForSmartDevice), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::ScanResult), 328, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleClientConnState), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::GattClientConditionList), 116, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattService), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattAttributeUuid), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattCharacteristic), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattDescriptor), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleDataPath), 24, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtm, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtm))

    // void GetStateImpl(nn::sf::Out<nn::btm::BtmState> pState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetStateImpl, (::nn::sf::Out<::nn::btm::BtmState> pState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateImpl)
    }

    // void GetHostDevicePropertyImpl(nn::sf::Out<nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetHostDevicePropertyImpl, (::nn::sf::Out<::nn::btm::HostDeviceProperty> pHostDeviceProperty))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostDevicePropertyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pHostDeviceProperty)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostDevicePropertyImpl)
    }

    // bool AcquireDeviceConditionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceConditionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireDeviceConditionEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireDeviceConditionEventImpl)
    }

    // void GetDeviceConditionImpl(nn::sf::Out<nn::btm::DeviceConditionList> pList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceConditionImpl, (::nn::sf::Out<::nn::btm::DeviceConditionList> pList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceConditionImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceConditionImpl)
    }

    // nn::Result SetBurstModeImpl(nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBurstModeImpl, (::nn::btm::BdAddress bdAddress, bool isBurstMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBurstModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isBurstMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBurstModeImpl)
    }

    // nn::Result SetSlotModeImpl(const nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSlotModeImpl, (const ::nn::btm::DeviceSlotModeList& deviceSlotModeList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSlotModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceSlotModeList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSlotModeImpl)
    }

    // nn::Result SetBluetoothModeImpl(nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBluetoothModeImpl, (::nn::btm::BluetoothMode bluetoothMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBluetoothModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBluetoothModeImpl)
    }

    // nn::Result SetWlanModeImpl(nn::btm::WlanMode wlanMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWlanModeImpl, (::nn::btm::WlanMode wlanMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWlanModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(wlanMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWlanModeImpl)
    }

    // bool AcquireDeviceInfoEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDeviceInfoEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireDeviceInfoEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireDeviceInfoEventImpl)
    }

    // void GetDeviceInfoImpl(nn::sf::Out<nn::btm::DeviceInfoList> pList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDeviceInfoImpl, (::nn::sf::Out<::nn::btm::DeviceInfoList> pList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceInfoImpl)
    }

    // void AddDeviceInfoImpl(const nn::btm::DeviceInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(AddDeviceInfoImpl, (const ::nn::btm::DeviceInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddDeviceInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddDeviceInfoImpl)
    }

    // void RemoveDeviceInfoImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(RemoveDeviceInfoImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveDeviceInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveDeviceInfoImpl)
    }

    // void IncreaseDeviceInfoOrderImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(IncreaseDeviceInfoOrderImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IncreaseDeviceInfoOrderImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IncreaseDeviceInfoOrderImpl)
    }

    // nn::Result LlrNotifyImpl(nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LlrNotifyImpl, (::nn::btm::BdAddress address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LlrNotifyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LlrNotifyImpl)
    }

    // void EnableRadioImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableRadioImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableRadioImpl)
    }

    // void DisableRadioImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableRadioImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableRadioImpl)
    }

    // void HidDisconnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(HidDisconnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidDisconnectImpl)
    }

    // nn::Result HidSetRetransmissionModeImpl(nn::btm::BdAddress bdAddress, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSetRetransmissionModeImpl, (::nn::btm::BdAddress bdAddress, const ::nn::btm::ZeroRetransmissionList& zeroRetransmissionList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidSetRetransmissionModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(zeroRetransmissionList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidSetRetransmissionModeImpl)
    }

    // bool AcquireAwakeReqEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireAwakeReqEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireAwakeReqEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireAwakeReqEventImpl)
    }

    // bool AcquireLlrStateEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireLlrStateEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireLlrStateEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireLlrStateEventImpl)
    }

    // bool IsLlrStartedImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsLlrStartedImpl, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsLlrStartedImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsLlrStartedImpl)
    }

    // void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableSlotSavingImpl, (bool isEnable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableSlotSavingImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableSlotSavingImpl)
    }

    // void ProtectDeviceInfoImpl(nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(ProtectDeviceInfoImpl, (::nn::btm::BdAddress address, bool isProtect))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ProtectDeviceInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isProtect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ProtectDeviceInfoImpl)
    }

    // bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleScanEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleScanEventImpl)
    }

    // nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanParameterGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameterId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanParameterGeneralImpl)
    }

    // nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanParameterSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameterId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanParameterSmartDeviceImpl)
    }

    // nn::Result StartBleScanForGeneralImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForGeneralImpl)
    }

    // nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForGeneralImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForGeneralImpl)
    }

    // void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanResultsForGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanResultsForGeneralImpl)
    }

    // nn::Result StartBleScanForPairedDeviceImpl(nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForPairedDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForPairedDeviceImpl)
    }

    // nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForPairedDeviceImpl)
    }

    // nn::Result StartBleScanForSmartDeviceImpl(const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForSmartDeviceImpl)
    }

    // nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForSmartDeviceImpl)
    }

    // void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanResultsForSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanResultsForSmartDeviceImpl)
    }

    // bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleConnectionEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleConnectionEventImpl)
    }

    // nn::Result BleConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleConnectImpl)
    }

    // nn::Result BleOverrideConnectionImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleOverrideConnectionImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleOverrideConnectionImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleOverrideConnectionImpl)
    }

    // nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleDisconnectImpl)
    }

    // void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleGetConnectionStateImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pConnState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleGetConnectionStateImpl)
    }

    // void BleGetGattClientConditionListImpl(nn::sf::Out<nn::btm::GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetGattClientConditionListImpl, (::nn::sf::Out<::nn::btm::GattClientConditionList> pGattClientConditionList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleGetGattClientConditionListImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pGattClientConditionList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleGetGattClientConditionListImpl)
    }

    // bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBlePairingEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBlePairingEventImpl)
    }

    // nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BlePairDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BlePairDeviceImpl)
    }

    // nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleUnpairDeviceOnBothImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleUnpairDeviceOnBothImpl)
    }

    // nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleUnpairDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleUnpairDeviceImpl)
    }

    // void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleGetPairedAddressesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAddresses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleGetPairedAddressesImpl)
    }

    // bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleServiceDiscoveryEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleServiceDiscoveryEventImpl)
    }

    // void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattServicesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pServices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattServicesImpl)
    }

    // bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattServiceImpl)
    }

    // void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattIncludedServicesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pIncludedServices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattIncludedServicesImpl)
    }

    // bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBelongingServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attributeHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBelongingServiceImpl)
    }

    // void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattCharacteristicsImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCharacteristics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattCharacteristicsImpl)
    }

    // void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattDescriptorsImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattDescriptorsImpl)
    }

    // bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleMtuConfigEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleMtuConfigEventImpl)
    }

    // nn::Result ConfigureBleMtuImpl(std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::std::uint32_t connectionHandle, ::std::uint16_t mtu))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfigureBleMtuImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mtu)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfigureBleMtuImpl)
    }

    // void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleMtuImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mtu)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleMtuImpl)
    }

    // nn::Result RegisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBleGattDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBleGattDataPathImpl)
    }

    // nn::Result UnregisterBleGattDataPathImpl(const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterBleGattDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterBleGattDataPathImpl)
    }

    // nn::Result RegisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t appletId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t appletId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterAppletResourceUserIdImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterAppletResourceUserIdImpl)
    }

    // nn::Result UnregisterAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAppletResourceUserIdImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAppletResourceUserIdImpl)
    }

    // nn::Result SetAppletResourceUserIdImpl(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAppletResourceUserIdImpl, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAppletResourceUserIdImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAppletResourceUserIdImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtm>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtm))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostDevicePropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostDevicePropertyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pHostDeviceProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireDeviceConditionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireDeviceConditionEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceConditionImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBurstModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBurstModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isBurstMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSlotModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(deviceSlotModeList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSlotModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(deviceSlotModeList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBluetoothModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBluetoothModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWlanModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWlanModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(wlanMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireDeviceInfoEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireDeviceInfoEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddDeviceInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveDeviceInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IncreaseDeviceInfoOrderImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IncreaseDeviceInfoOrderImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LlrNotifyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LlrNotifyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidSetRetransmissionModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(zeroRetransmissionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidSetRetransmissionModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(zeroRetransmissionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireAwakeReqEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireAwakeReqEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireLlrStateEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireLlrStateEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsLlrStartedImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsLlrStartedImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableSlotSavingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableSlotSavingImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ProtectDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ProtectDeviceInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isProtect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleScanEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleScanEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanParameterGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanParameterGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pFilter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameterId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanParameterSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanParameterSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pFilter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameterId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanResultsForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanResultsForGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForPairedDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanResultsForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanResultsForSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleConnectionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleConnectionEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleOverrideConnectionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleOverrideConnectionImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleGetConnectionStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pConnState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleGetConnectionStateImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pConnState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleGetGattClientConditionListImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pGattClientConditionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleGetGattClientConditionListImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pGattClientConditionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBlePairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBlePairingEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BlePairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BlePairDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleUnpairDeviceOnBothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleUnpairDeviceOnBothImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleUnpairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleUnpairDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleGetPairedAddressesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pAddresses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleGetPairedAddressesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pAddresses),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleServiceDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleServiceDiscoveryEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pServices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattServicesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pServices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattIncludedServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pIncludedServices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattIncludedServicesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pIncludedServices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBelongingServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBelongingServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attributeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattCharacteristicsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pCharacteristics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattCharacteristicsImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pCharacteristics),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattDescriptorsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pDescriptors)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattDescriptorsImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleMtuConfigEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleMtuConfigEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfigureBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfigureBleMtuImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mtu)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleMtuImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mtu),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBleGattDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterBleGattDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterAppletResourceUserIdImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterAppletResourceUserIdImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAppletResourceUserIdImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAppletResourceUserIdImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAppletResourceUserIdImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAppletResourceUserIdImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostDevicePropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireDeviceConditionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBurstModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSlotModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBluetoothModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWlanModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireDeviceInfoEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IncreaseDeviceInfoOrderImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LlrNotifyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidSetRetransmissionModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireAwakeReqEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireLlrStateEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsLlrStartedImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableSlotSavingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ProtectDeviceInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleScanEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanParameterGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanParameterSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanResultsForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanResultsForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleConnectionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleOverrideConnectionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleGetConnectionStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleGetGattClientConditionListImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBlePairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BlePairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleUnpairDeviceOnBothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleUnpairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleGetPairedAddressesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleServiceDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattIncludedServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBelongingServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattCharacteristicsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattDescriptorsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleMtuConfigEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfigureBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterAppletResourceUserIdImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAppletResourceUserIdImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAppletResourceUserIdImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtm))

namespace nn { namespace btm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtmDebug, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtmDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetDevicePropertyImpl, (::nn::sf::Out<::nn::btm::DevicePropertyList> pList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTsiModeImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::TsiMode tsiMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GeneralTestImpl, (::std::int32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(HidConnectImpl, (::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GeneralGetImpl, (::std::int32_t mode, ::nn::sf::Out<::nn::btm::GeneralInfoList> pList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetGattClientDisconnectionReasonImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutReason, ::std::uint32_t connectionHandle, ::nn::btm::BdAddress address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutInterval, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterRequestImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutIntervalMin, ::nn::sf::Out<::std::uint16_t> pOutIntervalMax, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtmDebug)

        bool AcquireDiscoveryEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireDiscoveryEventImpl, (bool), (handle));
        }

        ::nn::Result StartDiscoveryImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartDiscoveryImpl);
        }

        ::nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl);
        }

        void GetDevicePropertyImpl(::nn::sf::Out<::nn::btm::DevicePropertyList> pList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetDevicePropertyImpl, (pList));
        }

        ::nn::Result CreateBondImpl(::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateBondImpl, (bdAddress));
        }

        ::nn::Result CancelBondImpl(::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelBondImpl, (bdAddress));
        }

        ::nn::Result SetTsiModeImpl(::nn::btm::BdAddress bdAddress, ::nn::btm::TsiMode tsiMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTsiModeImpl, (bdAddress, tsiMode));
        }

        void GeneralTestImpl(::std::int32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GeneralTestImpl, (mode));
        }

        void HidConnectImpl(::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(HidConnectImpl, (bdAddress));
        }

        void GeneralGetImpl(::std::int32_t mode, ::nn::sf::Out<::nn::btm::GeneralInfoList> pList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GeneralGetImpl, (mode, pList));
        }

        bool GetGattClientDisconnectionReasonImpl(::nn::sf::Out<::std::uint16_t> pOutReason, ::std::uint32_t connectionHandle, ::nn::btm::BdAddress address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetGattClientDisconnectionReasonImpl, (bool), (pOutReason, connectionHandle, address));
        }

        bool GetBleConnectionParameterImpl(::nn::sf::Out<::std::uint16_t> pOutInterval, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetBleConnectionParameterImpl, (bool), (pOutInterval, pOutLatency, pOutTimeout, connectionHandle));
        }

        bool GetBleConnectionParameterRequestImpl(::nn::sf::Out<::std::uint16_t> pOutIntervalMin, ::nn::sf::Out<::std::uint16_t> pOutIntervalMax, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetBleConnectionParameterRequestImpl, (bool), (pOutIntervalMin, pOutIntervalMax, pOutLatency, pOutTimeout, connectionHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtmDebug
    {
    public:
        bool AcquireDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
        nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
        void GetDevicePropertyImpl(nn::sf::Out<nn::btm::DevicePropertyList> pList) NN_NOEXCEPT;
        nn::Result CreateBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        nn::Result CancelBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        nn::Result SetTsiModeImpl(nn::btm::BdAddress bdAddress, nn::btm::TsiMode tsiMode) NN_NOEXCEPT;
        void GeneralTestImpl(std::int32_t mode) NN_NOEXCEPT;
        void HidConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        void GeneralGetImpl(std::int32_t mode, nn::sf::Out<nn::btm::GeneralInfoList> pList) NN_NOEXCEPT;
        bool GetGattClientDisconnectionReasonImpl(nn::sf::Out<std::uint16_t> pOutReason, std::uint32_t connectionHandle, nn::btm::BdAddress address) NN_NOEXCEPT;
        bool GetBleConnectionParameterImpl(nn::sf::Out<std::uint16_t> pOutInterval, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT;
        bool GetBleConnectionParameterRequestImpl(nn::sf::Out<std::uint16_t> pOutIntervalMin, nn::sf::Out<std::uint16_t> pOutIntervalMax, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    bool AcquireDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
    void GetDevicePropertyImpl(nn::sf::Out<nn::btm::DevicePropertyList> pList) NN_NOEXCEPT;
    nn::Result CreateBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result CancelBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result SetTsiModeImpl(nn::btm::BdAddress bdAddress, nn::btm::TsiMode tsiMode) NN_NOEXCEPT;
    void GeneralTestImpl(std::int32_t mode) NN_NOEXCEPT;
    void HidConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    void GeneralGetImpl(std::int32_t mode, nn::sf::Out<nn::btm::GeneralInfoList> pList) NN_NOEXCEPT;
    bool GetGattClientDisconnectionReasonImpl(nn::sf::Out<std::uint16_t> pOutReason, std::uint32_t connectionHandle, nn::btm::BdAddress address) NN_NOEXCEPT;
    bool GetBleConnectionParameterImpl(nn::sf::Out<std::uint16_t> pOutInterval, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetBleConnectionParameterRequestImpl(nn::sf::Out<std::uint16_t> pOutIntervalMin, nn::sf::Out<std::uint16_t> pOutIntervalMax, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtmDebug))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireDiscoveryEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartDiscoveryImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelDiscoveryImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDevicePropertyImpl, (::nn::sf::Out<::nn::btm::DevicePropertyList> pList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetDevicePropertyImpl, (pList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateBondImpl, (bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelBondImpl, (bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTsiModeImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::TsiMode tsiMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTsiModeImpl, (bdAddress, tsiMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GeneralTestImpl, (::std::int32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GeneralTestImpl, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(HidConnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(HidConnectImpl, (bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GeneralGetImpl, (::std::int32_t mode, ::nn::sf::Out<::nn::btm::GeneralInfoList> pList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GeneralGetImpl, (mode, pList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattClientDisconnectionReasonImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutReason, ::std::uint32_t connectionHandle, ::nn::btm::BdAddress address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetGattClientDisconnectionReasonImpl, (bool), (pOutReason, connectionHandle, address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutInterval, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetBleConnectionParameterImpl, (bool), (pOutInterval, pOutLatency, pOutTimeout, connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterRequestImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutIntervalMin, ::nn::sf::Out<::std::uint16_t> pOutIntervalMax, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetBleConnectionParameterRequestImpl, (bool), (pOutIntervalMin, pOutIntervalMax, pOutLatency, pOutTimeout, connectionHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtmDebug>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtmDebug))

    // bool AcquireDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireDiscoveryEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireDiscoveryEventImpl)

    // nn::Result StartDiscoveryImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDiscoveryImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDiscoveryImpl)

    // nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelDiscoveryImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelDiscoveryImpl)

    // void GetDevicePropertyImpl(nn::sf::Out<nn::btm::DevicePropertyList> pList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDevicePropertyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pList, 0, (::nn::sf::Out<::nn::btm::DevicePropertyList>), 616, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDevicePropertyImpl)

    // nn::Result CreateBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateBondImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateBondImpl)

    // nn::Result CancelBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelBondImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelBondImpl)

    // nn::Result SetTsiModeImpl(nn::btm::BdAddress bdAddress, nn::btm::TsiMode tsiMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTsiModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(tsiMode, (::nn::btm::TsiMode), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bdAddress, tsiMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tsiMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTsiModeImpl)

    // void GeneralTestImpl(std::int32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GeneralTestImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GeneralTestImpl)

    // void HidConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bdAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidConnectImpl)

    // void GeneralGetImpl(std::int32_t mode, nn::sf::Out<nn::btm::GeneralInfoList> pList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GeneralGetImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pList, 0, (::nn::sf::Out<::nn::btm::GeneralInfoList>), 17, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GeneralGetImpl)

    // bool GetGattClientDisconnectionReasonImpl(nn::sf::Out<std::uint16_t> pOutReason, std::uint32_t connectionHandle, nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattClientDisconnectionReasonImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (address, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReason, (::std::uint16_t), 2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (NN_SF_DETAIL_OUT_RETURN_NAME, pOutReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReason), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattClientDisconnectionReasonImpl)

    // bool GetBleConnectionParameterImpl(nn::sf::Out<std::uint16_t> pOutInterval, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleConnectionParameterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutInterval, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutLatency, (::std::uint16_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTimeout, (::std::uint16_t), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(4, (NN_SF_DETAIL_OUT_RETURN_NAME, pOutInterval, pOutLatency, pOutTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutInterval), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutLatency), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTimeout), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleConnectionParameterImpl)

    // bool GetBleConnectionParameterRequestImpl(nn::sf::Out<std::uint16_t> pOutIntervalMin, nn::sf::Out<std::uint16_t> pOutIntervalMax, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleConnectionParameterRequestImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntervalMin, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntervalMax, (::std::uint16_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutLatency, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTimeout, (::std::uint16_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(5, (NN_SF_DETAIL_OUT_RETURN_NAME, pOutIntervalMin, pOutIntervalMax, pOutLatency, pOutTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(10)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntervalMin), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntervalMax), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutLatency), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTimeout), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleConnectionParameterRequestImpl)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::DevicePropertyList), 616, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::BdAddress), 6, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::TsiMode), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::GeneralInfoList), 17, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtmDebug, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtmDebug))

    // bool AcquireDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireDiscoveryEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireDiscoveryEventImpl)
    }

    // nn::Result StartDiscoveryImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDiscoveryImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDiscoveryImpl)
    }

    // nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelDiscoveryImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelDiscoveryImpl)
    }

    // void GetDevicePropertyImpl(nn::sf::Out<nn::btm::DevicePropertyList> pList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetDevicePropertyImpl, (::nn::sf::Out<::nn::btm::DevicePropertyList> pList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDevicePropertyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDevicePropertyImpl)
    }

    // nn::Result CreateBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateBondImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateBondImpl)
    }

    // nn::Result CancelBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelBondImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelBondImpl)
    }

    // nn::Result SetTsiModeImpl(nn::btm::BdAddress bdAddress, nn::btm::TsiMode tsiMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTsiModeImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::TsiMode tsiMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTsiModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tsiMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTsiModeImpl)
    }

    // void GeneralTestImpl(std::int32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GeneralTestImpl, (::std::int32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GeneralTestImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GeneralTestImpl)
    }

    // void HidConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(HidConnectImpl, (::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidConnectImpl)
    }

    // void GeneralGetImpl(std::int32_t mode, nn::sf::Out<nn::btm::GeneralInfoList> pList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GeneralGetImpl, (::std::int32_t mode, ::nn::sf::Out<::nn::btm::GeneralInfoList> pList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GeneralGetImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GeneralGetImpl)
    }

    // bool GetGattClientDisconnectionReasonImpl(nn::sf::Out<std::uint16_t> pOutReason, std::uint32_t connectionHandle, nn::btm::BdAddress address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattClientDisconnectionReasonImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutReason, ::std::uint32_t connectionHandle, ::nn::btm::BdAddress address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattClientDisconnectionReasonImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattClientDisconnectionReasonImpl)
    }

    // bool GetBleConnectionParameterImpl(nn::sf::Out<std::uint16_t> pOutInterval, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutInterval, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleConnectionParameterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutInterval)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutLatency)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTimeout)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleConnectionParameterImpl)
    }

    // bool GetBleConnectionParameterRequestImpl(nn::sf::Out<std::uint16_t> pOutIntervalMin, nn::sf::Out<std::uint16_t> pOutIntervalMax, nn::sf::Out<std::uint16_t> pOutLatency, nn::sf::Out<std::uint16_t> pOutTimeout, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBleConnectionParameterRequestImpl, (bool), (::nn::sf::Out<::std::uint16_t> pOutIntervalMin, ::nn::sf::Out<::std::uint16_t> pOutIntervalMax, ::nn::sf::Out<::std::uint16_t> pOutLatency, ::nn::sf::Out<::std::uint16_t> pOutTimeout, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleConnectionParameterRequestImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntervalMin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntervalMax)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutLatency)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTimeout)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleConnectionParameterRequestImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtmDebug>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtmDebug))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireDiscoveryEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDevicePropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDevicePropertyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateBondImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelBondImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTsiModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTsiModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(tsiMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GeneralTestImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GeneralTestImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GeneralGetImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GeneralGetImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattClientDisconnectionReasonImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattClientDisconnectionReasonImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReason),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleConnectionParameterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutInterval),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutLatency),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTimeout),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleConnectionParameterRequestImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleConnectionParameterRequestImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntervalMin),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntervalMax),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutLatency),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTimeout),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDevicePropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTsiModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GeneralTestImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GeneralGetImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattClientDisconnectionReasonImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleConnectionParameterRequestImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtmDebug))

namespace nn { namespace btm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtmSystem, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtmSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmSystemCore>> pOutService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtmSystem)

        void GetCoreImpl(::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetCoreImpl, (pOutService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtmSystem
    {
    public:
        void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtmSystem))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmSystemCore>> pOutService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetCoreImpl, (pOutService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtmSystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtmSystem))

    // void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCoreImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCoreImpl)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtmSystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtmSystem))

    // void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmSystemCore>> pOutService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCoreImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCoreImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtmSystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtmSystem))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCoreImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::btm::IBtmSystemCore>), pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCoreImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCoreImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtmSystem))

namespace nn { namespace btm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtmSystemCore, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtmSystemCore)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartGamepadPairingImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(CancelGamepadPairingImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(ClearGamepadPairingDatabaseImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetPairedGamepadCountImpl, (::nn::sf::Out<::std::uint8_t> pPairedGamepadCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetRadioOnOffImpl, (::nn::sf::Out<bool> pIsRadioOn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireRadioEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireGamepadPairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsGamepadPairingStartedImpl, (bool))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtmSystemCore)

        ::nn::Result StartGamepadPairingImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartGamepadPairingImpl);
        }

        void CancelGamepadPairingImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(CancelGamepadPairingImpl);
        }

        void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(ClearGamepadPairingDatabaseImpl);
        }

        void GetPairedGamepadCountImpl(::nn::sf::Out<::std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetPairedGamepadCountImpl, (pPairedGamepadCount));
        }

        void EnableRadioImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableRadioImpl);
        }

        void DisableRadioImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableRadioImpl);
        }

        void GetRadioOnOffImpl(::nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetRadioOnOffImpl, (pIsRadioOn));
        }

        bool AcquireRadioEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireRadioEventImpl, (bool), (handle));
        }

        bool AcquireGamepadPairingEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireGamepadPairingEventImpl, (bool), (handle));
        }

        bool IsGamepadPairingStartedImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsGamepadPairingStartedImpl, (bool));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtmSystemCore
    {
    public:
        nn::Result StartGamepadPairingImpl() NN_NOEXCEPT;
        void CancelGamepadPairingImpl() NN_NOEXCEPT;
        void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT;
        void GetPairedGamepadCountImpl(nn::sf::Out<std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT;
        void EnableRadioImpl() NN_NOEXCEPT;
        void DisableRadioImpl() NN_NOEXCEPT;
        void GetRadioOnOffImpl(nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT;
        bool AcquireRadioEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        bool AcquireGamepadPairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        bool IsGamepadPairingStartedImpl() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result StartGamepadPairingImpl() NN_NOEXCEPT;
    void CancelGamepadPairingImpl() NN_NOEXCEPT;
    void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT;
    void GetPairedGamepadCountImpl(nn::sf::Out<std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT;
    void EnableRadioImpl() NN_NOEXCEPT;
    void DisableRadioImpl() NN_NOEXCEPT;
    void GetRadioOnOffImpl(nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT;
    bool AcquireRadioEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    bool AcquireGamepadPairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    bool IsGamepadPairingStartedImpl() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtmSystemCore))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartGamepadPairingImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartGamepadPairingImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(CancelGamepadPairingImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(CancelGamepadPairingImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ClearGamepadPairingDatabaseImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(ClearGamepadPairingDatabaseImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetPairedGamepadCountImpl, (::nn::sf::Out<::std::uint8_t> pPairedGamepadCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetPairedGamepadCountImpl, (pPairedGamepadCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableRadioImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableRadioImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetRadioOnOffImpl, (::nn::sf::Out<bool> pIsRadioOn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetRadioOnOffImpl, (pIsRadioOn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireRadioEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireRadioEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireGamepadPairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireGamepadPairingEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsGamepadPairingStartedImpl, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsGamepadPairingStartedImpl, (bool));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtmSystemCore>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtmSystemCore))

    // nn::Result StartGamepadPairingImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartGamepadPairingImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartGamepadPairingImpl)

    // void CancelGamepadPairingImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelGamepadPairingImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelGamepadPairingImpl)

    // void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearGamepadPairingDatabaseImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearGamepadPairingDatabaseImpl)

    // void GetPairedGamepadCountImpl(nn::sf::Out<std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPairedGamepadCountImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pPairedGamepadCount, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pPairedGamepadCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pPairedGamepadCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPairedGamepadCountImpl)

    // void EnableRadioImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableRadioImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableRadioImpl)

    // void DisableRadioImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableRadioImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableRadioImpl)

    // void GetRadioOnOffImpl(nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRadioOnOffImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pIsRadioOn, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pIsRadioOn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pIsRadioOn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRadioOnOffImpl)

    // bool AcquireRadioEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireRadioEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireRadioEventImpl)

    // bool AcquireGamepadPairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireGamepadPairingEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireGamepadPairingEventImpl)

    // bool IsGamepadPairingStartedImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsGamepadPairingStartedImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsGamepadPairingStartedImpl)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtmSystemCore, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtmSystemCore))

    // nn::Result StartGamepadPairingImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartGamepadPairingImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartGamepadPairingImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartGamepadPairingImpl)
    }

    // void CancelGamepadPairingImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(CancelGamepadPairingImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelGamepadPairingImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelGamepadPairingImpl)
    }

    // void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ClearGamepadPairingDatabaseImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearGamepadPairingDatabaseImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearGamepadPairingDatabaseImpl)
    }

    // void GetPairedGamepadCountImpl(nn::sf::Out<std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetPairedGamepadCountImpl, (::nn::sf::Out<::std::uint8_t> pPairedGamepadCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPairedGamepadCountImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pPairedGamepadCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPairedGamepadCountImpl)
    }

    // void EnableRadioImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableRadioImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableRadioImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableRadioImpl)
    }

    // void DisableRadioImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableRadioImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableRadioImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableRadioImpl)
    }

    // void GetRadioOnOffImpl(nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetRadioOnOffImpl, (::nn::sf::Out<bool> pIsRadioOn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRadioOnOffImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pIsRadioOn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRadioOnOffImpl)
    }

    // bool AcquireRadioEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireRadioEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireRadioEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireRadioEventImpl)
    }

    // bool AcquireGamepadPairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireGamepadPairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireGamepadPairingEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireGamepadPairingEventImpl)
    }

    // bool IsGamepadPairingStartedImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsGamepadPairingStartedImpl, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsGamepadPairingStartedImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsGamepadPairingStartedImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtmSystemCore>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtmSystemCore))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearGamepadPairingDatabaseImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearGamepadPairingDatabaseImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPairedGamepadCountImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPairedGamepadCountImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pPairedGamepadCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRadioOnOffImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRadioOnOffImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pIsRadioOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireRadioEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireRadioEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireGamepadPairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireGamepadPairingEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsGamepadPairingStartedImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsGamepadPairingStartedImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelGamepadPairingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearGamepadPairingDatabaseImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPairedGamepadCountImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRadioOnOffImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireRadioEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireGamepadPairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsGamepadPairingStartedImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtmSystemCore))

namespace nn { namespace btm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtmUser, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtmUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmUserCore>> pOutService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtmUser)

        void GetCoreImpl(::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetCoreImpl, (pOutService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtmUser
    {
    public:
        void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtmUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmUserCore>> pOutService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetCoreImpl, (pOutService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtmUser>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtmUser))

    // void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCoreImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCoreImpl)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtmUser, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtmUser))

    // void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCoreImpl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::btm::IBtmUserCore>> pOutService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCoreImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCoreImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtmUser>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtmUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCoreImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::btm::IBtmUserCore>), pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCoreImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCoreImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtmUser))

namespace nn { namespace btm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBtmUserCore, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBtmUserCore)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::BdAddress bdAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t mtu))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBtmUserCore)

        bool AcquireBleScanEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (handle));
        }

        ::nn::Result GetBleScanParameterGeneralImpl(::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (pFilter, parameterId));
        }

        ::nn::Result GetBleScanParameterSmartDeviceImpl(::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (pFilter, parameterId));
        }

        ::nn::Result StartBleScanForGeneralImpl(::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (aruid, filter));
        }

        ::nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl);
        }

        void GetBleScanResultsForGeneralImpl(const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (pResult, pOutNum, aruid));
        }

        ::nn::Result StartBleScanForPairedDeviceImpl(::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (aruid, filter));
        }

        ::nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl);
        }

        ::nn::Result StartBleScanForSmartDeviceImpl(::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (aruid, filter));
        }

        ::nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl);
        }

        void GetBleScanResultsForSmartDeviceImpl(const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (pResult, pOutNum, aruid));
        }

        bool AcquireBleConnectionEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (handle));
        }

        ::nn::Result BleConnectImpl(::nn::applet::AppletResourceUserId aruid, ::nn::btm::BdAddress bdAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleConnectImpl, (aruid, bdAddress));
        }

        ::nn::Result BleDisconnectImpl(::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (connectionHandle));
        }

        void BleGetConnectionStateImpl(const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (pConnState, pOutNum, aruid));
        }

        bool AcquireBlePairingEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (handle));
        }

        ::nn::Result BlePairDeviceImpl(::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (connectionHandle, filter));
        }

        ::nn::Result BleUnpairDeviceOnBothImpl(::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (connectionHandle, filter));
        }

        ::nn::Result BleUnpairDeviceImpl(::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (bdAddress, filter));
        }

        void BleGetPairedAddressesImpl(const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (pAddresses, pOutNum, filter));
        }

        bool AcquireBleServiceDiscoveryEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (handle));
        }

        void GetGattServicesImpl(const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattServicesImpl, (pServices, pOutNum, aruid, connectionHandle));
        }

        bool GetGattServiceImpl(::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (pService, aruid, connectionHandle, uuid));
        }

        void GetGattIncludedServicesImpl(const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (pIncludedServices, pOutNum, aruid, connectionHandle, serviceHandle));
        }

        bool GetBelongingServiceImpl(::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (pService, aruid, connectionHandle, attributeHandle));
        }

        void GetGattCharacteristicsImpl(const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (pCharacteristics, pOutNum, aruid, connectionHandle, serviceHandle));
        }

        void GetGattDescriptorsImpl(const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (pDescriptors, pOutNum, aruid, connectionHandle, charHandle));
        }

        bool AcquireBleMtuConfigEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (handle));
        }

        ::nn::Result ConfigureBleMtuImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t mtu) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (aruid, connectionHandle, mtu));
        }

        void GetBleMtuImpl(::nn::sf::Out<::std::uint16_t> mtu, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetBleMtuImpl, (mtu, aruid, connectionHandle));
        }

        ::nn::Result RegisterBleGattDataPathImpl(::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (aruid, path));
        }

        ::nn::Result UnregisterBleGattDataPathImpl(::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (aruid, path));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBtmUserCore
    {
    public:
        bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
        nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
        nn::Result StartBleScanForGeneralImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
        void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StartBleScanForPairedDeviceImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;
        nn::Result StartBleScanForSmartDeviceImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT;
        nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
        void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result BleConnectImpl(nn::applet::AppletResourceUserId aruid, nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
        nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
        void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
        bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT;
        bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
        bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT;
        void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
        void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT;
        bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result ConfigureBleMtuImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT;
        void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT;
        nn::Result RegisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
        nn::Result UnregisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
    nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT;
    nn::Result StartBleScanForGeneralImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
    void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StartBleScanForPairedDeviceImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;
    nn::Result StartBleScanForSmartDeviceImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT;
    nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
    void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BleConnectImpl(nn::applet::AppletResourceUserId aruid, nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT;
    void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
    bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT;
    void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT;
    bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result ConfigureBleMtuImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT;
    void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT;
    nn::Result RegisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
    nn::Result UnregisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::btm::IBtmUserCore))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (pFilter, parameterId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (pFilter, parameterId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForGeneralImpl, (aruid, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForGeneralImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (pResult, pOutNum, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (aruid, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (aruid, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (pResult, pOutNum, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::BdAddress bdAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleConnectImpl, (aruid, bdAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleDisconnectImpl, (connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(BleGetConnectionStateImpl, (pConnState, pOutNum, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BlePairDeviceImpl, (connectionHandle, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (connectionHandle, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BleUnpairDeviceImpl, (bdAddress, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(BleGetPairedAddressesImpl, (pAddresses, pOutNum, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattServicesImpl, (pServices, pOutNum, aruid, connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetGattServiceImpl, (bool), (pService, aruid, connectionHandle, uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattIncludedServicesImpl, (pIncludedServices, pOutNum, aruid, connectionHandle, serviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (pService, aruid, connectionHandle, attributeHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattCharacteristicsImpl, (pCharacteristics, pOutNum, aruid, connectionHandle, serviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetGattDescriptorsImpl, (pDescriptors, pOutNum, aruid, connectionHandle, charHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t mtu))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfigureBleMtuImpl, (aruid, connectionHandle, mtu));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetBleMtuImpl, (mtu, aruid, connectionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (aruid, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (aruid, path));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::btm::IBtmUserCore>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::btm::IBtmUserCore))

    // bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleScanEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleScanEventImpl)

    // nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanParameterGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameterId, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (parameterId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pFilter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFilter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameterId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanParameterGeneralImpl)

    // nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanParameterSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameterId, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (parameterId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pFilter, (::nn::btm::user::BleAdvFilterForSmartDevice), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFilter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameterId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanParameterSmartDeviceImpl)

    // nn::Result StartBleScanForGeneralImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForGeneralImpl)

    // nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForGeneralImpl)

    // void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanResultsForGeneralImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pResult, 0, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pResult))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanResultsForGeneralImpl)

    // nn::Result StartBleScanForPairedDeviceImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForPairedDeviceImpl)

    // nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForPairedDeviceImpl)

    // nn::Result StartBleScanForSmartDeviceImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartBleScanForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForSmartDevice), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartBleScanForSmartDeviceImpl)

    // nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopBleScanForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopBleScanForSmartDeviceImpl)

    // void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleScanResultsForSmartDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pResult, 0, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pResult))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleScanResultsForSmartDeviceImpl)

    // bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleConnectionEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleConnectionEventImpl)

    // nn::Result BleConnectImpl(nn::applet::AppletResourceUserId aruid, nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bdAddress, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleConnectImpl)

    // nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleDisconnectImpl)

    // void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleGetConnectionStateImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pConnState, 0, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pConnState))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pConnState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleGetConnectionStateImpl)

    // bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBlePairingEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBlePairingEventImpl)

    // nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BlePairDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BlePairDeviceImpl)

    // nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleUnpairDeviceOnBothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (filter, connectionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleUnpairDeviceOnBothImpl)

    // nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleUnpairDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bdAddress, (::nn::btm::BdAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bdAddress, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(14)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bdAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleUnpairDeviceImpl)

    // void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BleGetPairedAddressesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pAddresses, 0, (const ::nn::sf::OutArray<::nn::btm::BdAddress>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pAddresses))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::btm::user::BleAdvFilterForGeneral), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAddresses), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BleGetPairedAddressesImpl)

    // bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleServiceDiscoveryEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleServiceDiscoveryEventImpl)

    // void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattServicesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pServices, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattService>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pServices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pServices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattServicesImpl)

    // bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pService, 0, (::nn::sf::Out<::nn::btm::user::GattService>), 36, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (connectionHandle, uuid, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattServiceImpl)

    // void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattIncludedServicesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pIncludedServices, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattService>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pIncludedServices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (serviceHandle, connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pIncludedServices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattIncludedServicesImpl)

    // bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBelongingServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pService, 0, (::nn::sf::Out<::nn::btm::user::GattService>), 36, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attributeHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attributeHandle, connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attributeHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBelongingServiceImpl)

    // void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattCharacteristicsImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pCharacteristics, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pCharacteristics))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (serviceHandle, connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCharacteristics), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattCharacteristicsImpl)

    // void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGattDescriptorsImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pDescriptors, 0, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pDescriptors))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charHandle, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (charHandle, connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNum, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDescriptors), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGattDescriptorsImpl)

    // bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireBleMtuConfigEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireBleMtuConfigEventImpl)

    // nn::Result ConfigureBleMtuImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfigureBleMtuImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mtu, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (mtu, connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mtu)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfigureBleMtuImpl)

    // void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBleMtuImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connectionHandle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mtu, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mtu))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mtu), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBleMtuImpl)

    // nn::Result RegisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBleGattDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(path, (::nn::btm::user::BleDataPath), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (path, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBleGattDataPathImpl)

    // nn::Result UnregisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterBleGattDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(path, (::nn::btm::user::BleDataPath), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (path, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterBleGattDataPathImpl)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleAdvFilterForGeneral), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleAdvFilterForSmartDevice), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::ScanResult), 328, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::BdAddress), 6, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleClientConnState), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattService), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattAttributeUuid), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattCharacteristic), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::GattDescriptor), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::btm::user::BleDataPath), 24, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::btm::IBtmUserCore, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::btm::IBtmUserCore))

    // bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleScanEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleScanEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleScanEventImpl)
    }

    // nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForGeneral> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterGeneralImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForGeneral> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanParameterGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameterId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanParameterGeneralImpl)
    }

    // nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<nn::btm::user::BleAdvFilterForSmartDevice> pFilter, std::uint16_t parameterId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBleScanParameterSmartDeviceImpl, (::nn::sf::Out<::nn::btm::user::BleAdvFilterForSmartDevice> pFilter, ::std::uint16_t parameterId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanParameterSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameterId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanParameterSmartDeviceImpl)
    }

    // nn::Result StartBleScanForGeneralImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForGeneralImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForGeneralImpl)
    }

    // nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForGeneralImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForGeneralImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForGeneralImpl)
    }

    // void GetBleScanResultsForGeneralImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForGeneralImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanResultsForGeneralImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanResultsForGeneralImpl)
    }

    // nn::Result StartBleScanForPairedDeviceImpl(nn::applet::AppletResourceUserId aruid, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForPairedDeviceImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForPairedDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForPairedDeviceImpl)
    }

    // nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForPairedDeviceImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForPairedDeviceImpl)
    }

    // nn::Result StartBleScanForSmartDeviceImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleAdvFilterForSmartDevice& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartBleScanForSmartDeviceImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleAdvFilterForSmartDevice& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartBleScanForSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartBleScanForSmartDeviceImpl)
    }

    // nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopBleScanForSmartDeviceImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopBleScanForSmartDeviceImpl)
    }

    // void GetBleScanResultsForSmartDeviceImpl(const nn::sf::OutArray<nn::btm::user::ScanResult>& pResult, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleScanResultsForSmartDeviceImpl, (const ::nn::sf::OutArray<::nn::btm::user::ScanResult>& pResult, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleScanResultsForSmartDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleScanResultsForSmartDeviceImpl)
    }

    // bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleConnectionEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleConnectionEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleConnectionEventImpl)
    }

    // nn::Result BleConnectImpl(nn::applet::AppletResourceUserId aruid, nn::btm::BdAddress bdAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::nn::btm::BdAddress bdAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleConnectImpl)
    }

    // nn::Result BleDisconnectImpl(std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleDisconnectImpl, (::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleDisconnectImpl)
    }

    // void BleGetConnectionStateImpl(const nn::sf::OutArray<nn::btm::user::BleClientConnState>& pConnState, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetConnectionStateImpl, (const ::nn::sf::OutArray<::nn::btm::user::BleClientConnState>& pConnState, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleGetConnectionStateImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pConnState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleGetConnectionStateImpl)
    }

    // bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBlePairingEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBlePairingEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBlePairingEventImpl)
    }

    // nn::Result BlePairDeviceImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlePairDeviceImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BlePairDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BlePairDeviceImpl)
    }

    // nn::Result BleUnpairDeviceOnBothImpl(std::uint32_t connectionHandle, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceOnBothImpl, (::std::uint32_t connectionHandle, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleUnpairDeviceOnBothImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleUnpairDeviceOnBothImpl)
    }

    // nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BleUnpairDeviceImpl, (::nn::btm::BdAddress bdAddress, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleUnpairDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bdAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleUnpairDeviceImpl)
    }

    // void BleGetPairedAddressesImpl(const nn::sf::OutArray<nn::btm::BdAddress>& pAddresses, nn::sf::Out<std::uint8_t> pOutNum, nn::btm::user::BleAdvFilterForGeneral filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(BleGetPairedAddressesImpl, (const ::nn::sf::OutArray<::nn::btm::BdAddress>& pAddresses, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::btm::user::BleAdvFilterForGeneral filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BleGetPairedAddressesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAddresses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BleGetPairedAddressesImpl)
    }

    // bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleServiceDiscoveryEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleServiceDiscoveryEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleServiceDiscoveryEventImpl)
    }

    // void GetGattServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattServicesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pServices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattServicesImpl)
    }

    // bool GetGattServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetGattServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattServiceImpl)
    }

    // void GetGattIncludedServicesImpl(const nn::sf::OutArray<nn::btm::user::GattService>& pIncludedServices, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattIncludedServicesImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattService>& pIncludedServices, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattIncludedServicesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pIncludedServices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattIncludedServicesImpl)
    }

    // bool GetBelongingServiceImpl(nn::sf::Out<nn::btm::user::GattService> pService, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t attributeHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBelongingServiceImpl, (bool), (::nn::sf::Out<::nn::btm::user::GattService> pService, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t attributeHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBelongingServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attributeHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBelongingServiceImpl)
    }

    // void GetGattCharacteristicsImpl(const nn::sf::OutArray<nn::btm::user::GattCharacteristic>& pCharacteristics, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t serviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattCharacteristicsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattCharacteristic>& pCharacteristics, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t serviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattCharacteristicsImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCharacteristics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattCharacteristicsImpl)
    }

    // void GetGattDescriptorsImpl(const nn::sf::OutArray<nn::btm::user::GattDescriptor>& pDescriptors, nn::sf::Out<std::uint8_t> pOutNum, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t charHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetGattDescriptorsImpl, (const ::nn::sf::OutArray<::nn::btm::user::GattDescriptor>& pDescriptors, ::nn::sf::Out<::std::uint8_t> pOutNum, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t charHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGattDescriptorsImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDescriptors)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGattDescriptorsImpl)
    }

    // bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(AcquireBleMtuConfigEventImpl, (bool), (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireBleMtuConfigEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireBleMtuConfigEventImpl)
    }

    // nn::Result ConfigureBleMtuImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfigureBleMtuImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle, ::std::uint16_t mtu))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfigureBleMtuImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mtu)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfigureBleMtuImpl)
    }

    // void GetBleMtuImpl(nn::sf::Out<std::uint16_t> mtu, nn::applet::AppletResourceUserId aruid, std::uint32_t connectionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetBleMtuImpl, (::nn::sf::Out<::std::uint16_t> mtu, ::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connectionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBleMtuImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mtu)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBleMtuImpl)
    }

    // nn::Result RegisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBleGattDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBleGattDataPathImpl)
    }

    // nn::Result UnregisterBleGattDataPathImpl(nn::applet::AppletResourceUserId aruid, const nn::btm::user::BleDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBleGattDataPathImpl, (::nn::applet::AppletResourceUserId aruid, const ::nn::btm::user::BleDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterBleGattDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterBleGattDataPathImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::btm::IBtmUserCore>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::btm::IBtmUserCore))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleScanEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleScanEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanParameterGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanParameterGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pFilter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameterId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanParameterSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanParameterSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pFilter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameterId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanResultsForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanResultsForGeneralImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForPairedDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartBleScanForSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleScanResultsForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleScanResultsForSmartDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleConnectionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleConnectionEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleGetConnectionStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pConnState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleGetConnectionStateImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pConnState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBlePairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBlePairingEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BlePairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BlePairDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleUnpairDeviceOnBothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleUnpairDeviceOnBothImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleUnpairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleUnpairDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bdAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BleGetPairedAddressesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pAddresses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BleGetPairedAddressesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pAddresses),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleServiceDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleServiceDiscoveryEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pServices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattServicesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pServices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattIncludedServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pIncludedServices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattIncludedServicesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pIncludedServices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBelongingServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBelongingServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attributeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattCharacteristicsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pCharacteristics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattCharacteristicsImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pCharacteristics),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGattDescriptorsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pDescriptors)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGattDescriptorsImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pDescriptors),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireBleMtuConfigEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireBleMtuConfigEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfigureBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfigureBleMtuImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mtu)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBleMtuImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mtu),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBleGattDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterBleGattDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleScanEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanParameterGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanParameterSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanResultsForGeneralImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopBleScanForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleScanResultsForSmartDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleConnectionEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleGetConnectionStateImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBlePairingEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BlePairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleUnpairDeviceOnBothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleUnpairDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BleGetPairedAddressesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleServiceDiscoveryEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattIncludedServicesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBelongingServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattCharacteristicsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGattDescriptorsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireBleMtuConfigEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfigureBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBleMtuImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBleGattDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterBleGattDataPathImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::btm::IBtmUserCore))
