﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      bpc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_BPC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_BPC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_BPC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_BPC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_BPC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_BPC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_BPC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_BPC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_BPC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_BPC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_BPC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_BPC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_BPC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_BPC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_BPC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_BPC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_BPC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_BPC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_BPC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_BPC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(bpc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_BPC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Trace, 0, format, args)
#define NN_DETAIL_BPC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Trace, 1, format, args)
#define NN_DETAIL_BPC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Trace, 2, format, args)
#define NN_DETAIL_BPC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Trace, 3, format, args)

#define NN_DETAIL_BPC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Info, 0, format, args)
#define NN_DETAIL_BPC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Info, 1, format, args)
#define NN_DETAIL_BPC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Info, 2, format, args)
#define NN_DETAIL_BPC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Info, 3, format, args)

#define NN_DETAIL_BPC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Warn, 0, format, args)
#define NN_DETAIL_BPC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Warn, 1, format, args)
#define NN_DETAIL_BPC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Warn, 2, format, args)
#define NN_DETAIL_BPC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Warn, 3, format, args)

#define NN_DETAIL_BPC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Error, 0, format, args)
#define NN_DETAIL_BPC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Error, 1, format, args)
#define NN_DETAIL_BPC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Error, 2, format, args)
#define NN_DETAIL_BPC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Error, 3, format, args)

#define NN_DETAIL_BPC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Fatal, 0, format, args)
#define NN_DETAIL_BPC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Fatal, 1, format, args)
#define NN_DETAIL_BPC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Fatal, 2, format, args)
#define NN_DETAIL_BPC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(bpc, Fatal, 3, format, args)

#define NN_DETAIL_BPC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Trace, 0, text, length)
#define NN_DETAIL_BPC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Trace, 1, text, length)
#define NN_DETAIL_BPC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Trace, 2, text, length)
#define NN_DETAIL_BPC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Trace, 3, text, length)

#define NN_DETAIL_BPC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Info, 0, text, length)
#define NN_DETAIL_BPC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Info, 1, text, length)
#define NN_DETAIL_BPC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Info, 2, text, length)
#define NN_DETAIL_BPC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Info, 3, text, length)

#define NN_DETAIL_BPC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Warn, 0, text, length)
#define NN_DETAIL_BPC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Warn, 1, text, length)
#define NN_DETAIL_BPC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Warn, 2, text, length)
#define NN_DETAIL_BPC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Warn, 3, text, length)

#define NN_DETAIL_BPC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Error, 0, text, length)
#define NN_DETAIL_BPC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Error, 1, text, length)
#define NN_DETAIL_BPC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Error, 2, text, length)
#define NN_DETAIL_BPC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Error, 3, text, length)

#define NN_DETAIL_BPC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Fatal, 0, text, length)
#define NN_DETAIL_BPC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Fatal, 1, text, length)
#define NN_DETAIL_BPC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Fatal, 2, text, length)
#define NN_DETAIL_BPC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(bpc, Fatal, 3, text, length)
