﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>
#include <nn/bpc/bpc_IBoardPowerControlManager.sfdl.h>
#include <nn/bpc/bpc_IRtcManager.sfdl.h>

namespace nn {
namespace bpc {

// IBoardPowerControlManager 実装クラス
class BoardPowerControlManagerImpl : public nn::sf::ISharedObject
{
public:
    BoardPowerControlManagerImpl() NN_NOEXCEPT;
    ~BoardPowerControlManagerImpl() NN_NOEXCEPT;
    nn::Result ShutdownSystem() NN_NOEXCEPT;
    nn::Result RebootSystem() NN_NOEXCEPT;
    nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutWakeupReason) NN_NOEXCEPT;
    nn::Result GetShutdownReason(nn::sf::Out<std::uint32_t> pOutShutdownReason) NN_NOEXCEPT;
    nn::Result GetAcOk(nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT;
    nn::Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, BoardPowerControlEventTarget target) NN_NOEXCEPT;
    nn::Result GetSleepButtonState(nn::sf::Out<nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT;
    nn::Result GetPowerButtonEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, EventTarget target) NN_NOEXCEPT;
    nn::Result CreateWakeupTimer(nn::sf::Out<int> outTimerHandle, nn::TimeSpanType interval) NN_NOEXCEPT;
    nn::Result CreateWakeupTimerEx(nn::sf::Out<int> outTimerHandle, nn::TimeSpanType interval, WakeupTimerType type) NN_NOEXCEPT;
    nn::Result CancelWakeupTimer(int timerHandle) NN_NOEXCEPT;
    nn::Result EnableWakeupTimerOnDevice(nn::sf::Out<bool> outIsEnabled, nn::sf::Out<int> outTimerHandle, nn::sf::Out<WakeupTimerType> outWakeupTimerType) NN_NOEXCEPT;
    nn::Result GetLastEnabledWakeupTimerType(nn::sf::Out<WakeupTimerType> outWakeupTimerType) NN_NOEXCEPT;
    nn::Result CleanAllWakeupTimers(WakeupTimerType type) NN_NOEXCEPT;
};

// IRtcManager 実装クラス
class RtcManagerImpl : public nn::sf::ISharedObject
{
public:
    RtcManagerImpl() NN_NOEXCEPT;
    ~RtcManagerImpl() NN_NOEXCEPT;
    nn::Result GetRtcTime(nn::sf::Out<int64_t> outRtcTimeInSeconds) NN_NOEXCEPT;
    nn::Result SetRtcTime(int64_t rtcTimeInSeconds) NN_NOEXCEPT;
    nn::Result GetRtcResetDetected(nn::sf::Out<bool> outRtcResetDetected) NN_NOEXCEPT;
    nn::Result ClearRtcResetDetected() NN_NOEXCEPT;
    nn::Result SetUpRtcResetOnShutdown() NN_NOEXCEPT;
};

}} // namespace nn::bpc
