﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>
#include <nn/bcat/detail/service/msgpack/bcat_MsgpackEventHandler.h>
#include <nn/bcat/detail/service/msgpack/bcat_JsonPath.h>
#include <nn/msgpack.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace msgpack {

/*!
    @brief      MessagePack リーダーです。
*/
class MsgpackReader
{
public:
    /*!
        @brief      コンストラクタです。
    */
    MsgpackReader() NN_NOEXCEPT;

    /*!
        @brief      MessagePack をパースします。

        @param[in]  stream      入力ストリーム。
        @param[in]  handler     イベントハンドラ。
        @param[in]  tokenSize   パースするトークンの最大サイズ。

        @return     処理結果。

        @details
                    独自のイベントハンドラを設定することで、入力する MessagePack データに応じたハンドリングを行うことが可能です。

                    トークンのサイズが tokenSize を超える場合、イベントハンドラのオーバーフローフラグが true になります。
    */
    nn::Result Parse(nne::nlib::InputStream& stream, MsgpackEventHandler& handler, size_t tokenSize = 4 * 1024) NN_NOEXCEPT;

private:
    //
    JsonPath m_JsonPath;

private:
    //
    nn::Result ParseImpl(nne::nlib::msgpack::JsonStreamParser& parser, MsgpackEventHandler& handler) NN_NOEXCEPT;
};

}}}}}
