﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <algorithm>
#include <atomic>
#include <cstdio>
#include <mutex>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/fs.h>
#include <nn/time.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Uuid.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/bcat/bcat_Result.h>
#include <nn/bcat/bcat_ResultPrivate.h>
#include <nn/bcat/bcat_Types.h>
#include <nn/bcat/bcat_TypesAdmin.h>
#include <nn/bcat/bcat_TypesDebug.h>
#include <nn/bcat/bcat_TypesSystem.h>

#include <nn/bcat/detail/bcat_Log.h>
#include <nn/bcat/detail/bcat_TypesDetail.h>

#include <nn/bcat/detail/ipc/bcat_ServiceConfig.h>

#include <nn/bcat/detail/service/core/bcat_DeliveryCacheStorageManager.h>
#include <nn/bcat/detail/service/core/bcat_FileSystem.h>
#include <nn/bcat/detail/service/core/bcat_IdIssuer.h>
#include <nn/bcat/detail/service/core/bcat_ParameterConverter.h>
#include <nn/bcat/detail/service/util/bcat_Account.h>
#include <nn/bcat/detail/service/util/bcat_Random.h>

#include <nn/bcat/service/bcat_TypesService.h>
