﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/bcat/detail/ipc/bcat_IBcatService.sfdl.h>
#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheStorageService.sfdl.h>
#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheProgressService.sfdl.h>

namespace nn { namespace bcat { namespace detail { namespace ipc {

/*!
    @brief      IPC サービスの初期化を行います。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      IPC サービスの終了処理を行います。
*/
void Finalize() NN_NOEXCEPT;

/*!
    @brief      BcatService を作成します。

    @param[out] outService  BcatService。

    @return     処理結果。
*/
nn::Result CreateBcatService(IBcatService** outService) NN_NOEXCEPT;

/*!
    @brief      DeliveryCacheStorageService を作成します。

    @param[out] outService  DeliveryCacheStorageService。

    @return     処理結果。
*/
nn::Result CreateDeliveryCacheStorageService(IDeliveryCacheStorageService** outService) NN_NOEXCEPT;

/*!
    @brief      DeliveryCacheStorageService を作成します。

    @param[out] outService  DeliveryCacheStorageService。
    @param[in]  appId       アプリケーション ID。

    @return     処理結果。
*/
nn::Result CreateDeliveryCacheStorageService(IDeliveryCacheStorageService** outService, nn::ApplicationId appId) NN_NOEXCEPT;

}}}}
