﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/bcat_TypesSystem.h>
#include <nn/nn_ApplicationId.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace bcat {

/*!
    @brief      システムが管理するプッシュ通知のログの最大数です。
*/
const int PushNotificationLogCountMax = TaskCountMax * 2;

/*!
    @brief      タスク情報です。
*/
struct TaskInfo
{
    nn::ApplicationId appId;              //!< アプリケーション ID。
    uint32_t appVersion;                  //!< アプリケーションバージョン。
    NN_PADDING4;
    TaskStatus status;                    //!< タスクの状態。
    SubscriptionStatus subscription;      //!< NPNS トピックの購読状態。
    NN_PADDING2;
    int32_t lastError;                    //!< 最後のエラー。
    nn::time::PosixTime lastRunTime;      //!< 最終実行時刻（ネットワーク時刻）。
    nn::time::PosixTime nextRunnableTime; //!< 次回実行可能時刻（ネットワーク時刻）。
    nn::time::PosixTime registrationTime; //!< 登録時刻（ネットワーク時刻）。
    NN_PADDING8;
    NN_PADDING8;
};

/*!
    @brief      プッシュ通知の受信ログです。
*/
struct PushNotificationLog
{
    nn::ApplicationId appId;          //!< アプリケーション ID。
    nn::time::PosixTime receivedTime; //!< 受信時刻（ネットワーク時刻）。
};

}}
