﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief       オーディオコントローラに関する公開ヘッダファイルです。
 */

namespace nn { namespace audioctrl {

/**
 * @brief       音声入出力を操作するターゲット
 */
enum AudioTarget
{
    AudioTarget_Invalid = 0,
    AudioTarget_Speaker,          //!< 本体内蔵スピーカ
    AudioTarget_Headphone,        //!< ヘッドホン
    AudioTarget_Tv,               //!< TV 出力
    AudioTarget_UsbOutputDevice,  //!< USB 出力機器
    AudioTarget_Count,            //!< nn::audioctrl::AudioTarget 列挙体の個数
};

/**
 * @brief       音声入出力設定
 */
enum AudioOutputMode
{
    AudioOutputMode_Invalid = 0,
    AudioOutputMode_Pcm1ch,       //!< PCM, モノラル
    AudioOutputMode_Pcm2ch,       //!< PCM, ステレオ
    AudioOutputMode_Pcm6ch,       //!< PCM, 5.1 チャンネルサラウンド
    AudioOutputMode_PcmAuto,      //!< PCM, 自動
};

/**
 * @brief       強制ミュート機能のポリシー
 */
enum ForceMutePolicy
{
    ForceMutePolicy_Disable = 0,  //!< 無効
    ForceMutePolicy_SpeakerMuteOnHeadphoneUnplugged, //!< ヘッドホンが抜かれた時にスピーカを強制ミュート
};

/**
 * @brief       ヘッドホン出力レベルの設定
 */
enum HeadphoneOutputLevelMode
{
    HeadphoneOutputLevelMode_Normal = 0, //!< 通常音量で出力
    HeadphoneOutputLevelMode_HighPower,  //!< 大音量で出力
};

/**
 * @brief       システム出力マスターボリューム変更時に指定できる最小ボリューム値です。
 */
const float SystemOutputMasterVolumeMin = 0.0f;

/**
 * @brief       システム出力マスターボリューム変更時に指定できる最大ボリューム値です。
 */
const float SystemOutputMasterVolumeMax = 1.0f;

}}  // namespace nn::audioctrl
