﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/audio/audio_AudioInTypes.h>
#include <nn/audio/detail/audio_AudioInTypesInternal.h>
#include <nn/audio/detail/audio_IAudioIn.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IAudioInManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioInManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioInManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioIns, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioIn, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAuto, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInAuto, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAutoFiltered, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInProtocolSpecified, (::std::uint64_t protocolVersion, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioInManager)

        ::nn::Result ListAudioIns(const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAudioIns, (outAudioIn, amountRet));
        }

        ::nn::Result OpenAudioIn(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAudioIn, (outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
        }

        ::nn::Result ListAudioInsAuto(const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAudioInsAuto, (outAudioIn, amountRet));
        }

        ::nn::Result OpenAudioInAuto(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAudioInAuto, (outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
        }

        ::nn::Result ListAudioInsAutoFiltered(const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAudioInsAutoFiltered, (outAudioIn, amountRet));
        }

        ::nn::Result OpenAudioInProtocolSpecified(::std::uint64_t protocolVersion, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAudioInProtocolSpecified, (protocolVersion, outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioInManager
    {
    public:
        nn::Result ListAudioIns(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
        nn::Result OpenAudioIn(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
        nn::Result ListAudioInsAuto(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
        nn::Result OpenAudioInAuto(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
        nn::Result ListAudioInsAutoFiltered(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
        nn::Result OpenAudioInProtocolSpecified(std::uint64_t protocolVersion, nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ListAudioIns(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
    nn::Result OpenAudioIn(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
    nn::Result ListAudioInsAuto(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
    nn::Result OpenAudioInAuto(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
    nn::Result ListAudioInsAutoFiltered(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
    nn::Result OpenAudioInProtocolSpecified(std::uint64_t protocolVersion, nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IAudioInManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioIns, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAudioIns, (outAudioIn, amountRet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioIn, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAudioIn, (outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAuto, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAudioInsAuto, (outAudioIn, amountRet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInAuto, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAudioInAuto, (outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAutoFiltered, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAudioInsAutoFiltered, (outAudioIn, amountRet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInProtocolSpecified, (::std::uint64_t protocolVersion, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAudioInProtocolSpecified, (protocolVersion, outAudioIn, nameIn, param, ::std::move(processHandle), audioOutInter, nameOut, appletId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IAudioInManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IAudioInManager))

    // nn::Result ListAudioIns(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAudioIns)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioIn, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(amountRet, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (amountRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(amountRet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAudioIns)

    // nn::Result OpenAudioIn(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAudioIn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (nameIn, nameOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioIn, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(param, (::nn::audio::AudioInParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (param, appletId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(audioOutInter, (::nn::audio::detail::AudioInParameterInternal), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (audioOutInter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(param), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(audioOutInter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAudioIn)

    // nn::Result ListAudioInsAuto(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAudioInsAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioIn, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(amountRet, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (amountRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(amountRet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAudioInsAuto)

    // nn::Result OpenAudioInAuto(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAudioInAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (nameIn, nameOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioIn, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(param, (::nn::audio::AudioInParameter), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (param, appletId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(audioOutInter, (::nn::audio::detail::AudioInParameterInternal), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (audioOutInter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(param), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(audioOutInter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAudioInAuto)

    // nn::Result ListAudioInsAutoFiltered(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAudioInsAutoFiltered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioIn, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(amountRet, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (amountRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(amountRet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAudioInsAutoFiltered)

    // nn::Result OpenAudioInProtocolSpecified(std::uint64_t protocolVersion, nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAudioInProtocolSpecified)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (nameIn, nameOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioIn, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(protocolVersion, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(param, (::nn::audio::AudioInParameter), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (protocolVersion, param, appletId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(audioOutInter, (::nn::audio::detail::AudioInParameterInternal), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (audioOutInter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(protocolVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(param), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(audioOutInter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAudioInProtocolSpecified)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::audio::AudioInParameter), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::audio::detail::AudioInParameterInternal), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IAudioInManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IAudioInManager))

    // nn::Result ListAudioIns(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioIns, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAudioIns)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(amountRet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAudioIns)
    }

    // nn::Result OpenAudioIn(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioIn, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(param)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(audioOutInter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAudioIn)
    }

    // nn::Result ListAudioInsAuto(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAuto, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAudioInsAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(amountRet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAudioInsAuto)
    }

    // nn::Result OpenAudioInAuto(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInAuto, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAudioInAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(param)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(audioOutInter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAudioInAuto)
    }

    // nn::Result ListAudioInsAutoFiltered(const nn::sf::OutBuffer& outAudioIn, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioInsAutoFiltered, (const ::nn::sf::OutBuffer& outAudioIn, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAudioInsAutoFiltered)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(amountRet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAudioInsAutoFiltered)
    }

    // nn::Result OpenAudioInProtocolSpecified(std::uint64_t protocolVersion, nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioIn>> outAudioIn, const nn::sf::InBuffer& nameIn, nn::audio::AudioInParameter param, nn::sf::NativeHandle&& processHandle, nn::sf::Out<nn::audio::detail::AudioInParameterInternal> audioOutInter, const nn::sf::OutBuffer& nameOut, nn::applet::AppletResourceUserId appletId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioInProtocolSpecified, (::std::uint64_t protocolVersion, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>> outAudioIn, const ::nn::sf::InBuffer& nameIn, ::nn::audio::AudioInParameter param, ::nn::sf::NativeHandle&& processHandle, ::nn::sf::Out<::nn::audio::detail::AudioInParameterInternal> audioOutInter, const ::nn::sf::OutBuffer& nameOut, ::nn::applet::AppletResourceUserId appletId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAudioInProtocolSpecified)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(protocolVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(param)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(audioOutInter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAudioInProtocolSpecified)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IAudioInManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IAudioInManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAudioIns)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAudioIns)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(amountRet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>), outAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAudioIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(param),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(audioOutInter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioIn, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAudioInsAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAudioInsAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(amountRet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAudioInAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>), outAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAudioInAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(param),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(audioOutInter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioIn, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAudioInsAutoFiltered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAudioInsAutoFiltered)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(amountRet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAudioInProtocolSpecified)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioIn>), outAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAudioInProtocolSpecified)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(protocolVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(param),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(audioOutInter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioIn, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAudioIns)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAudioInsAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAudioInAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAudioInsAutoFiltered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAudioInProtocolSpecified)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IAudioInManager))
