﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IAudioIn;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioIn, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioIn)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInState, (::nn::sf::Out<::std::uint32_t> outAudioIn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Start)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffers, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ContainsAudioInBuffer, (::std::uint64_t audioBufferPointer, ::nn::sf::Out<bool> contains))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffersAuto, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInBufferCount, (::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceGain, (float gain))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceGain, (::nn::sf::Out<float> gain))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioIn)

        ::nn::Result GetAudioInState(::nn::sf::Out<::std::uint32_t> outAudioIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioInState, (outAudioIn));
        }

        ::nn::Result Start() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Start);
        }

        ::nn::Result Stop() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Stop);
        }

        ::nn::Result AppendAudioInBuffer(const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendAudioInBuffer, (outAudioInBuffer, outBufferClientPtr));
        }

        ::nn::Result RegisterBufferEvent(::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (bufferEvent));
        }

        ::nn::Result GetReleasedAudioInBuffers(const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffers, (outAudioBuffer, count));
        }

        ::nn::Result ContainsAudioInBuffer(::std::uint64_t audioBufferPointer, ::nn::sf::Out<bool> contains) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ContainsAudioInBuffer, (audioBufferPointer, contains));
        }

        ::nn::Result AppendUacInBuffer(const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendUacInBuffer, (outAudioInBuffer, outBufferClientPtr, ::std::move(inBufferHandle)));
        }

        ::nn::Result AppendAudioInBufferAuto(const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendAudioInBufferAuto, (outAudioInBuffer, outBufferClientPtr));
        }

        ::nn::Result GetReleasedAudioInBuffersAuto(const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffersAuto, (outAudioBuffer, count));
        }

        ::nn::Result AppendUacInBufferAuto(const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendUacInBufferAuto, (outAudioInBuffer, outBufferClientPtr, ::std::move(inBufferHandle)));
        }

        ::nn::Result GetAudioInBufferCount(::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioInBufferCount, (count));
        }

        ::nn::Result SetDeviceGain(float gain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDeviceGain, (gain));
        }

        ::nn::Result GetDeviceGain(::nn::sf::Out<float> gain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceGain, (gain));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioIn
    {
    public:
        nn::Result GetAudioInState(nn::sf::Out<std::uint32_t> outAudioIn) NN_NOEXCEPT;
        nn::Result Start() NN_NOEXCEPT;
        nn::Result Stop() NN_NOEXCEPT;
        nn::Result AppendAudioInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
        nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT;
        nn::Result GetReleasedAudioInBuffers(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result ContainsAudioInBuffer(std::uint64_t audioBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT;
        nn::Result AppendUacInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT;
        nn::Result AppendAudioInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
        nn::Result GetReleasedAudioInBuffersAuto(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result AppendUacInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT;
        nn::Result GetAudioInBufferCount(nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result SetDeviceGain(float gain) NN_NOEXCEPT;
        nn::Result GetDeviceGain(nn::sf::Out<float> gain) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetAudioInState(nn::sf::Out<std::uint32_t> outAudioIn) NN_NOEXCEPT;
    nn::Result Start() NN_NOEXCEPT;
    nn::Result Stop() NN_NOEXCEPT;
    nn::Result AppendAudioInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
    nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT;
    nn::Result GetReleasedAudioInBuffers(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result ContainsAudioInBuffer(std::uint64_t audioBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT;
    nn::Result AppendUacInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT;
    nn::Result AppendAudioInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
    nn::Result GetReleasedAudioInBuffersAuto(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result AppendUacInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT;
    nn::Result GetAudioInBufferCount(nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result SetDeviceGain(float gain) NN_NOEXCEPT;
    nn::Result GetDeviceGain(nn::sf::Out<float> gain) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IAudioIn))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInState, (::nn::sf::Out<::std::uint32_t> outAudioIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioInState, (outAudioIn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Start)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Start);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Stop);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendAudioInBuffer, (outAudioInBuffer, outBufferClientPtr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBufferEvent, (bufferEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffers, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReleasedAudioInBuffers, (outAudioBuffer, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContainsAudioInBuffer, (::std::uint64_t audioBufferPointer, ::nn::sf::Out<bool> contains))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ContainsAudioInBuffer, (audioBufferPointer, contains));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendUacInBuffer, (outAudioInBuffer, outBufferClientPtr, ::std::move(inBufferHandle)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendAudioInBufferAuto, (outAudioInBuffer, outBufferClientPtr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffersAuto, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReleasedAudioInBuffersAuto, (outAudioBuffer, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendUacInBufferAuto, (outAudioInBuffer, outBufferClientPtr, ::std::move(inBufferHandle)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInBufferCount, (::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioInBufferCount, (count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceGain, (float gain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDeviceGain, (gain));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceGain, (::nn::sf::Out<float> gain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceGain, (gain));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IAudioIn>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IAudioIn))

    // nn::Result GetAudioInState(nn::sf::Out<std::uint32_t> outAudioIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioInState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAudioIn, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outAudioIn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioInState)

    // nn::Result Start() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Start)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Start)

    // nn::Result Stop() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Stop)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Stop)

    // nn::Result AppendAudioInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendAudioInBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioInBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioInBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioInBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendAudioInBuffer)

    // nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBufferEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(bufferEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (bufferEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBufferEvent)

    // nn::Result GetReleasedAudioInBuffers(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReleasedAudioInBuffers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReleasedAudioInBuffers)

    // nn::Result ContainsAudioInBuffer(std::uint64_t audioBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ContainsAudioInBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(audioBufferPointer, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (audioBufferPointer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(contains, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (contains))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(audioBufferPointer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contains)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ContainsAudioInBuffer)

    // nn::Result AppendUacInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendUacInBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioInBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioInBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(inBufferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (inBufferHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioInBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendUacInBuffer)

    // nn::Result AppendAudioInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendAudioInBufferAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioInBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioInBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioInBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendAudioInBufferAuto)

    // nn::Result GetReleasedAudioInBuffersAuto(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReleasedAudioInBuffersAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReleasedAudioInBuffersAuto)

    // nn::Result AppendUacInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendUacInBufferAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAudioInBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAudioInBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(inBufferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (inBufferHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioInBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendUacInBufferAuto)

    // nn::Result GetAudioInBufferCount(nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioInBufferCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioInBufferCount)

    // nn::Result SetDeviceGain(float gain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDeviceGain)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(gain, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (gain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(gain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDeviceGain)

    // nn::Result GetDeviceGain(nn::sf::Out<float> gain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceGain)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(gain, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (gain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(gain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceGain)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IAudioIn, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IAudioIn))

    // nn::Result GetAudioInState(nn::sf::Out<std::uint32_t> outAudioIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInState, (::nn::sf::Out<::std::uint32_t> outAudioIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioInState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioInState)
    }

    // nn::Result Start() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Start)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Start)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Start)
    }

    // nn::Result Stop() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Stop)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Stop)
    }

    // nn::Result AppendAudioInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendAudioInBuffer)
    }

    // nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBufferEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBufferEvent)
    }

    // nn::Result GetReleasedAudioInBuffers(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffers, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReleasedAudioInBuffers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReleasedAudioInBuffers)
    }

    // nn::Result ContainsAudioInBuffer(std::uint64_t audioBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContainsAudioInBuffer, (::std::uint64_t audioBufferPointer, ::nn::sf::Out<bool> contains))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ContainsAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(audioBufferPointer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contains)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ContainsAudioInBuffer)
    }

    // nn::Result AppendUacInBuffer(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBuffer, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendUacInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendUacInBuffer)
    }

    // nn::Result AppendAudioInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendAudioInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendAudioInBufferAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendAudioInBufferAuto)
    }

    // nn::Result GetReleasedAudioInBuffersAuto(const nn::sf::OutBuffer& outAudioBuffer, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedAudioInBuffersAuto, (const ::nn::sf::OutBuffer& outAudioBuffer, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReleasedAudioInBuffersAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReleasedAudioInBuffersAuto)
    }

    // nn::Result AppendUacInBufferAuto(const nn::sf::InBuffer& outAudioInBuffer, std::uint64_t outBufferClientPtr, nn::sf::NativeHandle&& inBufferHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendUacInBufferAuto, (const ::nn::sf::InBuffer& outAudioInBuffer, ::std::uint64_t outBufferClientPtr, ::nn::sf::NativeHandle&& inBufferHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendUacInBufferAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioInBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendUacInBufferAuto)
    }

    // nn::Result GetAudioInBufferCount(nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioInBufferCount, (::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioInBufferCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioInBufferCount)
    }

    // nn::Result SetDeviceGain(float gain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceGain, (float gain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDeviceGain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(gain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDeviceGain)
    }

    // nn::Result GetDeviceGain(nn::sf::Out<float> gain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceGain, (::nn::sf::Out<float> gain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceGain)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(gain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceGain)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IAudioIn>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IAudioIn))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioInState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioInState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAudioIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendAudioInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioInBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(bufferEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBufferEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(bufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReleasedAudioInBuffers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReleasedAudioInBuffers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ContainsAudioInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ContainsAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(audioBufferPointer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(contains)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendUacInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(inBufferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendUacInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioInBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(inBufferHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendAudioInBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendAudioInBufferAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioInBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReleasedAudioInBuffersAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReleasedAudioInBuffersAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendUacInBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAudioInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(inBufferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendUacInBufferAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAudioInBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(inBufferHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioInBufferCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioInBufferCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDeviceGain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDeviceGain)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(gain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceGain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceGain)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(gain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioInState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendAudioInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReleasedAudioInBuffers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ContainsAudioInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendUacInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendAudioInBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReleasedAudioInBuffersAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendUacInBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioInBufferCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDeviceGain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceGain)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IAudioIn))
