﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>

#include <nn/audio/audio_Config.h>
#include <nn/audio/audio_Result.h>
#include <nn/audio/audio_SampleFormat.h>
#include <nn/audio/audio_FinalOutputRecorderTypes.h>

namespace nn {
namespace audio {

void InitializeFinalOutputRecorderParameter(FinalOutputRecorderParameter* param) NN_NOEXCEPT;

Result OpenFinalOutputRecorder(FinalOutputRecorder* pOutFinalOutputRecorder, nn::os::SystemEvent* pOutSystemEvent, const FinalOutputRecorderParameter& parameter) NN_NOEXCEPT;

Result OpenFinalOutputRecorder(FinalOutputRecorder* pOutFinalOutputRecorder, const FinalOutputRecorderParameter& parameter) NN_NOEXCEPT;

void CloseFinalOutputRecorder(FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

Result StartFinalOutputRecorder(FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

void StopFinalOutputRecorder(FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

FinalOutputRecorderState GetFinalOutputRecorderState(const FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

int GetFinalOutputRecorderSampleRate(const FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

int GetFinalOutputRecorderChannelCount(const FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

SampleFormat GetFinalOutputRecorderSampleFormat(const FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

NN_DEPRECATED void SetFinalOutputRecorderBufferInfo(FinalOutputRecorderBuffer* pOutFinalOutputRecorderBuffer, void* buffer, size_t size) NN_NOEXCEPT;

void SetFinalOutputRecorderBufferInfo(FinalOutputRecorderBuffer* pOutFinalOutputRecorderBuffer, void* buffer, size_t bufferSize, size_t dataSize) NN_NOEXCEPT;

void* GetFinalOutputRecorderBufferDataPointer(const FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

size_t GetFinalOutputRecorderBufferBufferSize(const FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

size_t GetFinalOutputRecorderBufferDataSize(const FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

void AppendFinalOutputRecorderBuffer(FinalOutputRecorder* pFinalOutputRecorder, FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

FinalOutputRecorderBuffer* GetReleasedFinalOutputRecorderBuffer(FinalOutputRecorder* pFinalOutputRecorder) NN_NOEXCEPT;

bool ContainsFinalOutputRecorderBuffer(const FinalOutputRecorder* pFinalOutputRecorder, const FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

nn::TimeSpan GetFinalOutputRecorderBufferEndTime(const FinalOutputRecorderBuffer* pFinalOutputRecorderBuffer) NN_NOEXCEPT;

int GetAdspLoad() NN_NOEXCEPT;

/**
 * @}
 */

}  // namespace audio
}  // namespace nn
